/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.wires.input;

import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.input.TaskSchedulerInput;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class InputWire<IN> {
    private final TaskSchedulerInput<?> taskSchedulerInput;
    private Consumer<Object> handler;
    private final String name;
    private final String taskSchedulerName;
    private final TaskSchedulerType taskSchedulerType;

    protected InputWire(@NonNull TaskScheduler<?> taskScheduler, @NonNull String name) {
        this.taskSchedulerInput = Objects.requireNonNull(taskScheduler);
        this.name = Objects.requireNonNull(name);
        this.taskSchedulerName = taskScheduler.getName();
        this.taskSchedulerType = taskScheduler.getType();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getTaskSchedulerName() {
        return this.taskSchedulerName;
    }

    @NonNull
    public TaskSchedulerType getTaskSchedulerType() {
        return this.taskSchedulerType;
    }

    public void put(@NonNull IN data) {
        this.taskSchedulerInput.put(this.handler, data);
    }

    public boolean offer(@NonNull IN data) {
        return this.taskSchedulerInput.offer(this.handler, data);
    }

    public void inject(@NonNull IN data) {
        this.taskSchedulerInput.inject(this.handler, data);
    }

    protected void setHandler(@NonNull Consumer<Object> handler) {
        if (this.handler != null) {
            throw new IllegalStateException("Handler already bound");
        }
        this.handler = Objects.requireNonNull(handler);
    }
}

