/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.virtualmap.internal.reconnect.VirtualReconnectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class PullVirtualTreeRequest
implements SelfSerializable {
    private static final long CLASS_ID = -1370238561956973313L;
    private long path;
    private Hash hash;

    public PullVirtualTreeRequest() {
    }

    public PullVirtualTreeRequest(long path, Hash hash) {
        assert (path == -1L || path >= 0L && hash != null);
        this.path = path;
        this.hash = hash;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.path);
        if (this.hash != null) {
            this.hash.getBytes().writeTo((OutputStream)out);
        }
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.path = in.readLong();
        if (this.path >= 0L) {
            byte[] hashBytes = new byte[DigestType.SHA_384.digestLength()];
            if (VirtualReconnectUtils.completelyRead((InputStream)in, hashBytes) != DigestType.SHA_384.digestLength()) {
                throw new IOException("Failed to read node hash from the learner");
            }
            this.hash = new Hash(hashBytes, DigestType.SHA_384);
        }
    }

    public long getPath() {
        return this.path;
    }

    public Hash getHash() {
        return this.hash;
    }

    public long getClassId() {
        return -1370238561956973313L;
    }

    public int getVersion() {
        return 1;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

