/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams.internal;

import com.swirlds.common.io.streams.internal.SerializationOperation;
import com.swirlds.common.io.streams.internal.SerializationStackElement;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;

public class SerializationStack {
    final Deque<SerializationStackElement> stack = new LinkedList<SerializationStackElement>();

    public SerializationStack(StackTraceElement callLocation) {
        this.stack.addLast(new SerializationStackElement(SerializationOperation.STREAM_OPENED, callLocation));
    }

    public void startOperation(SerializationOperation operation, StackTraceElement callLocation) {
        this.stack.addLast(new SerializationStackElement(operation, callLocation));
    }

    public void finishOperation() {
        SerializationStackElement finished = this.stack.removeLast();
        SerializationStackElement parent = Objects.requireNonNull(this.stack.getLast(), "stack should never be empty");
        parent.addChild(finished);
    }

    public void setClassId(long classId) {
        SerializationStackElement element = Objects.requireNonNull(this.stack.getLast(), "stack should never be empty");
        element.setClassId(classId);
    }

    public void setClass(Class<?> clazz) {
        SerializationStackElement element = Objects.requireNonNull(this.stack.getLast(), "stack should never be empty");
        element.setClass(clazz);
    }

    public void setStringRepresentation(String string) {
        SerializationStackElement element = Objects.requireNonNull(this.stack.getLast(), "stack should never be empty");
        element.setStringRepresentation(string);
    }

    public String generateSerializationStackTrace() {
        while (this.stack.size() > 1) {
            this.finishOperation();
        }
        StringBuilder sb = new StringBuilder();
        SerializationStackElement root = Objects.requireNonNull(this.stack.getLast(), "stack should never be empty");
        root.writeStackTrace(sb, 0);
        return sb.toString();
    }

    public Deque<SerializationStackElement> getInternalStack() {
        return this.stack;
    }
}

