/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.task;

import com.swirlds.common.merkle.synchronization.stats.ReconnectMapStats;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.ExpectedLesson;
import com.swirlds.common.merkle.synchronization.task.Lesson;
import com.swirlds.common.merkle.synchronization.task.QueryResponse;
import com.swirlds.common.merkle.synchronization.task.ReconnectNodeCount;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.base.utility.ThresholdLimitingHandler;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;

public class LearnerPushTask {
    private static final Logger logger = LogManager.getLogger(LearnerPushTask.class);
    private static final String NAME = "learner-task";
    private final StandardWorkGroup workGroup;
    private final AsyncInputStream<Lesson> in;
    private final AsyncOutputStream<QueryResponse> out;
    private final LearnerTreeView view;
    private final ReconnectNodeCount nodeCount;
    private final ReconnectMapStats mapStats;
    private final ThresholdLimitingHandler<Throwable> exceptionRateLimiter = new ThresholdLimitingHandler(1L);

    public LearnerPushTask(StandardWorkGroup workGroup, AsyncInputStream<Lesson> in, AsyncOutputStream<QueryResponse> out, LearnerTreeView view, ReconnectNodeCount nodeCount, @NonNull ReconnectMapStats mapStats) {
        this.workGroup = workGroup;
        this.in = in;
        this.out = out;
        this.view = view;
        this.nodeCount = nodeCount;
        this.mapStats = mapStats;
    }

    public void start() {
        this.workGroup.execute(NAME, this::run);
    }

    private Long extractNodeFromLesson(ExpectedLesson expectedLesson, Lesson lesson, boolean firstLesson) {
        if (lesson.isCurrentNodeUpToDate()) {
            return expectedLesson.getOriginalNode();
        }
        Long node = firstLesson ? expectedLesson.getOriginalNode() : lesson.getNode();
        return node;
    }

    private void handleQueries(LearnerTreeView view, AsyncInputStream<Lesson> in, AsyncOutputStream<QueryResponse> out, List<Hash> queries, Long originalParent, Long newParent) throws InterruptedException {
        int childCount = queries.size();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            Long originalChild = view.isInternal(originalParent, true) && view.getNumberOfChildren(originalParent) > childIndex ? view.getChild(originalParent, childIndex) : null;
            Hash originalHash = view.getNodeHash(originalChild);
            Hash teacherHash = queries.get(childIndex);
            if (originalHash == null) {
                this.exceptionRateLimiter.handle((Object)new NullPointerException(), error -> logger.warn(LogMarker.RECONNECT.getMarker(), "originalHash for node {} is null", (Object)originalChild));
            }
            boolean nodeAlreadyPresent = originalHash != null && originalHash.equals((Object)teacherHash);
            out.sendAsync(new QueryResponse(nodeAlreadyPresent));
            this.mapStats.incrementTransfersFromLearner();
            view.recordHashStats(this.mapStats, newParent, childIndex, nodeAlreadyPresent);
            view.expectLessonFor(newParent, childIndex, originalChild, nodeAlreadyPresent);
            in.anticipateMessage();
        }
    }

    private void addToNodeCount(ExpectedLesson expectedLesson, Lesson lesson, Long newChild) {
        if (lesson.isLeafLesson()) {
            this.mapStats.incrementLeafData(1, expectedLesson.isNodeAlreadyPresent() ? 1 : 0);
        }
        if (lesson.isCurrentNodeUpToDate()) {
            return;
        }
        if (this.view.isInternal(newChild, false)) {
            this.nodeCount.incrementInternalCount();
            if (expectedLesson.isNodeAlreadyPresent()) {
                this.nodeCount.incrementRedundantInternalCount();
            }
        } else {
            this.nodeCount.incrementLeafCount();
            if (expectedLesson.isNodeAlreadyPresent()) {
                this.nodeCount.incrementRedundantLeafCount();
            }
        }
    }

    private void run() {
        boolean firstLesson = true;
        try (AsyncInputStream<Lesson> asyncInputStream = this.in;
             AsyncOutputStream<QueryResponse> asyncOutputStream = this.out;
             LearnerTreeView learnerTreeView = this.view;){
            this.view.expectLessonFor(null, 0, 0L, false);
            this.in.anticipateMessage();
            while (this.view.hasNextExpectedLesson()) {
                ExpectedLesson expectedLesson = this.view.getNextExpectedLesson();
                Lesson lesson = this.in.readAnticipatedMessage();
                this.mapStats.incrementTransfersFromTeacher();
                Long parent = expectedLesson.getParent();
                Long newChild = this.extractNodeFromLesson(expectedLesson, lesson, firstLesson);
                firstLesson = false;
                if (parent != null) {
                    this.view.setChild(parent, expectedLesson.getPositionInParent(), newChild);
                }
                this.addToNodeCount(expectedLesson, lesson, newChild);
                if (!lesson.hasQueries()) continue;
                List<Hash> queries = lesson.getQueries();
                this.handleQueries(this.view, this.in, this.out, queries, expectedLesson.getOriginalNode(), newChild);
            }
            logger.info(LogMarker.RECONNECT.getMarker(), "learner thread finished the learning loop for the current subtree");
        }
        catch (InterruptedException ex) {
            logger.warn(LogMarker.RECONNECT.getMarker(), "learner thread interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "exception in the learner's receiving thread", (Throwable)ex);
            throw new MerkleSynchronizationException("exception in the learner's receiving thread", ex);
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "learner thread closed input, output, and view for the current subtree");
    }
}

