/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.builder;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.time.Time;
import com.swirlds.common.io.utility.SimpleRecycleBin;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.reconnect.ReconnectModule;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.StateLifecycleManagerImpl;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.merkle.VirtualMapStateImpl;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hiero.base.concurrent.BlockingResourceProvider;
import org.hiero.consensus.crypto.KeyGeneratingException;
import org.hiero.consensus.crypto.KeysAndCertsGenerator;
import org.hiero.consensus.crypto.SigningSchema;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.event.NoOpIntakeEventCounter;
import org.hiero.consensus.event.creator.EventCreatorModule;
import org.hiero.consensus.event.intake.EventIntakeModule;
import org.hiero.consensus.gossip.GossipModule;
import org.hiero.consensus.hashgraph.HashgraphModule;
import org.hiero.consensus.io.RecycleBin;
import org.hiero.consensus.metrics.noop.NoOpMetrics;
import org.hiero.consensus.metrics.statistics.EventPipelineTracker;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatusAction;
import org.hiero.consensus.monitoring.FallenBehindMonitor;
import org.hiero.consensus.pces.PcesModule;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.transaction.TransactionLimits;

public class ConsensusModuleBuilder {
    private ConsensusModuleBuilder() {
    }

    public static EventCreatorModule createEventCreatorModule() {
        return ServiceLoader.load(EventCreatorModule.class).findFirst().orElseThrow(() -> new IllegalStateException("No EventCreatorModule implementation found!"));
    }

    public static EventCreatorModule createNoOpEventCreatorModule(@NonNull WiringModel model, @NonNull Configuration configuration) {
        KeysAndCerts keysAndCerts;
        NoOpMetrics metrics = new NoOpMetrics();
        Time time = Time.getCurrent();
        NodeId selfId = NodeId.FIRST_NODE_ID;
        SecureRandom random = new SecureRandom();
        try {
            keysAndCerts = KeysAndCertsGenerator.generate((NodeId)selfId, (SigningSchema)SigningSchema.ED25519, (SecureRandom)random, (SecureRandom)random);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception thrown while creating dummy KeysAndCerts", e);
        }
        RosterEntry rosterEntry = new RosterEntry(selfId.id(), 0L, Bytes.EMPTY, List.of());
        Roster roster = new Roster(List.of(rosterEntry));
        EventCreatorModule eventCreatorModule = ConsensusModuleBuilder.createEventCreatorModule();
        eventCreatorModule.initialize(model, configuration, (Metrics)metrics, time, random, keysAndCerts, roster, selfId, List::of, () -> false);
        return eventCreatorModule;
    }

    public static EventIntakeModule createEventIntakeModule() {
        return ServiceLoader.load(EventIntakeModule.class).findFirst().orElseThrow(() -> new IllegalStateException("No EventIntakeModule implementation found!"));
    }

    public static EventIntakeModule createNoOpEventIntakeModule(@NonNull WiringModel model, @NonNull Configuration configuration) {
        NoOpMetrics metrics = new NoOpMetrics();
        Time time = Time.getCurrent();
        NodeId selfId = NodeId.FIRST_NODE_ID;
        RosterEntry rosterEntry = new RosterEntry(selfId.id(), 0L, Bytes.EMPTY, List.of());
        Roster roster = new Roster(List.of(rosterEntry));
        RosterHistory rosterHistory = new RosterHistory(List.of(new RoundRosterPair(0L, Bytes.EMPTY)), Map.of(Bytes.EMPTY, roster));
        NoOpIntakeEventCounter intakeEventCounter = new NoOpIntakeEventCounter();
        TransactionLimits transactionLimits = new TransactionLimits(0, 0);
        EventPipelineTracker eventPipelineTracker = null;
        EventIntakeModule eventIntakeModule = ConsensusModuleBuilder.createEventIntakeModule();
        eventIntakeModule.initialize(model, configuration, (Metrics)metrics, time, rosterHistory, (IntakeEventCounter)intakeEventCounter, transactionLimits, eventPipelineTracker);
        return eventIntakeModule;
    }

    @NonNull
    public static PcesModule createPcesModule() {
        return ServiceLoader.load(PcesModule.class).findFirst().orElseThrow(() -> new IllegalStateException("No PcesModule implementation found!"));
    }

    @NonNull
    public static PcesModule createNoOpPcesModule(@NonNull WiringModel model, @NonNull Configuration configuration) {
        NoOpMetrics metrics = new NoOpMetrics();
        Time time = Time.getCurrent();
        NodeId selfId = NodeId.FIRST_NODE_ID;
        SimpleRecycleBin recycleBin = new SimpleRecycleBin();
        long startingRound = 0L;
        Runnable flushIntake = () -> {};
        Runnable flushTransactionHandling = () -> {};
        Supplier<ReservedSignedState> latestImmutableStateSupplier = ReservedSignedState::createNullReservation;
        Consumer<PlatformStatusAction> statusActionConsumer = status -> {};
        Runnable stateHasherFlusher = () -> {};
        Runnable signalEndOfPcesReplay = () -> {};
        EventPipelineTracker eventPipelineTracker = null;
        PcesModule pcesModule = ConsensusModuleBuilder.createPcesModule();
        pcesModule.initialize(model, configuration, (Metrics)metrics, time, selfId, (RecycleBin)recycleBin, 0L, flushIntake, flushTransactionHandling, latestImmutableStateSupplier, statusActionConsumer, stateHasherFlusher, signalEndOfPcesReplay, eventPipelineTracker);
        return pcesModule;
    }

    public static HashgraphModule createHashgraphModule() {
        return ServiceLoader.load(HashgraphModule.class).findFirst().orElseThrow(() -> new IllegalStateException("No HashgraphModule implementation found!"));
    }

    public static HashgraphModule createNoOpHashgraphModule(@NonNull WiringModel model, @NonNull Configuration configuration) {
        NoOpMetrics metrics = new NoOpMetrics();
        Time time = Time.getCurrent();
        NodeId selfId = NodeId.FIRST_NODE_ID;
        RosterEntry rosterEntry = new RosterEntry(selfId.id(), 0L, Bytes.EMPTY, List.of());
        Roster roster = new Roster(List.of(rosterEntry));
        HashgraphModule hashgraphModule = ConsensusModuleBuilder.createHashgraphModule();
        EventPipelineTracker eventPipelineTracker = null;
        hashgraphModule.initialize(model, configuration, (Metrics)metrics, time, roster, selfId, instant -> false, eventPipelineTracker);
        return hashgraphModule;
    }

    @NonNull
    public static GossipModule createGossipModule() {
        return ServiceLoader.load(GossipModule.class).findFirst().orElseThrow(() -> new IllegalStateException("No GossipModule implementation found!"));
    }

    @NonNull
    public static GossipModule createNoOpGossipModule(@NonNull WiringModel model, @NonNull Configuration configuration) {
        Bytes certificate;
        KeysAndCerts keysAndCerts;
        NoOpMetrics metrics = new NoOpMetrics();
        Time time = Time.getCurrent();
        NodeId selfId = NodeId.FIRST_NODE_ID;
        try {
            keysAndCerts = KeysAndCertsGenerator.generate((NodeId)selfId);
            certificate = Bytes.wrap((byte[])keysAndCerts.sigCert().getEncoded());
        }
        catch (GeneralSecurityException | KeyGeneratingException e) {
            throw new RuntimeException(e);
        }
        RosterEntry rosterEntry = new RosterEntry(selfId.id(), 0L, certificate, List.of(ServiceEndpoint.DEFAULT));
        Roster roster = new Roster(List.of(rosterEntry));
        SemanticVersion appVersion = SemanticVersion.DEFAULT;
        NoOpIntakeEventCounter intakeEventCounter = new NoOpIntakeEventCounter();
        Supplier<ReservedSignedState> latestCompleteStateSupplier = ReservedSignedState::createNullReservation;
        BlockingResourceProvider reservedSignedStateResultPromise = new BlockingResourceProvider();
        FallenBehindMonitor fallenBehindMonitor = new FallenBehindMonitor(roster, configuration, (Metrics)metrics);
        StateLifecycleManagerImpl stateLifecycleManager = new StateLifecycleManagerImpl((Metrics)metrics, time, arg_0 -> ConsensusModuleBuilder.lambda$createNoOpGossipModule$12((Metrics)metrics, arg_0), configuration);
        GossipModule gossipModule = ConsensusModuleBuilder.createGossipModule();
        gossipModule.initialize(model, configuration, (Metrics)metrics, time, keysAndCerts, roster, selfId, appVersion, (IntakeEventCounter)intakeEventCounter, latestCompleteStateSupplier, reservedSignedStateResultPromise, fallenBehindMonitor, (StateLifecycleManager)stateLifecycleManager);
        return gossipModule;
    }

    @NonNull
    public static ReconnectModule createReconnectModule() {
        return ServiceLoader.load(ReconnectModule.class).findFirst().orElseThrow(() -> new IllegalStateException("No ReconnectModule implementation found!"));
    }

    private static /* synthetic */ VirtualMapState lambda$createNoOpGossipModule$12(Metrics metrics, VirtualMap vm) {
        return new VirtualMapStateImpl(vm, metrics);
    }
}

