/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.signed.SignedStateMetrics;
import com.swirlds.platform.state.signed.StateSignatureCollector;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Signature;
import org.hiero.base.crypto.SignatureType;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.sequence.set.SequenceSet;
import org.hiero.consensus.model.sequence.set.StandardSequenceSet;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.state.config.StateConfig;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;

public class DefaultStateSignatureCollector
implements StateSignatureCollector {
    private static final Logger logger = LogManager.getLogger(DefaultStateSignatureCollector.class);
    private long lastStateRound = -1L;
    private final Map<Long, ReservedSignedState> incompleteStates = new HashMap<Long, ReservedSignedState>();
    private final StateConfig stateConfig;
    private final SequenceSet<SavedSignature> savedSignatures;
    private final SignedStateMetrics signedStateMetrics;

    public DefaultStateSignatureCollector(@NonNull PlatformContext platformContext, @NonNull SignedStateMetrics signedStateMetrics) {
        this.stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
        this.signedStateMetrics = Objects.requireNonNull(signedStateMetrics);
        this.savedSignatures = new StandardSequenceSet(0L, this.stateConfig.maxAgeOfFutureStateSignatures(), SavedSignature::round);
    }

    @Override
    @Nullable
    public List<ReservedSignedState> addReservedState(@NonNull ReservedSignedState reservedSignedState) {
        Objects.requireNonNull(reservedSignedState, "reservedSignedState");
        SignedState signedState = reservedSignedState.get();
        if (signedState.getState().getHash() == null) {
            throw new IllegalArgumentException("Unhashed state for round " + signedState.getRound() + " added to the signed state manager");
        }
        signedState.pruneInvalidSignatures();
        List signatures = this.savedSignatures.getEntriesWithSequenceNumber(signedState.getRound());
        this.savedSignatures.removeSequenceNumber(signedState.getRound());
        signatures.forEach(ss -> this.addSignature(reservedSignedState, ss.memberId(), ss.signature()));
        this.lastStateRound = Math.max(this.lastStateRound, signedState.getRound());
        this.adjustSavedSignaturesWindow(signedState.getRound());
        if (!signedState.isComplete() && !signedState.isFreezeState()) {
            ReservedSignedState previousState = this.incompleteStates.put(signedState.getRound(), reservedSignedState);
            if (previousState != null) {
                previousState.close();
                logger.warn(LogMarker.EXCEPTION.getMarker(), "Two states with the same round ({}) have been added to the signature collector", (Object)signedState.getRound());
            }
            return Optional.of(this.purgeOldStates()).filter(l -> !l.isEmpty()).orElse(null);
        }
        return Stream.concat(Stream.of(reservedSignedState), this.purgeOldStates().stream()).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), l -> l.isEmpty() ? null : l));
    }

    @Override
    @Nullable
    public List<ReservedSignedState> handlePreconsensusSignatures(@NonNull Queue<ScopedSystemTransaction<StateSignatureTransaction>> transactions) {
        Objects.requireNonNull(transactions, "transactions");
        return transactions.stream().map(this::handlePreconsensusSignature).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), l -> l.isEmpty() ? null : l));
    }

    @Nullable
    private ReservedSignedState handlePreconsensusSignature(@NonNull ScopedSystemTransaction<StateSignatureTransaction> scopedTransaction) {
        ReservedSignedState reservedState;
        long round = ((StateSignatureTransaction)scopedTransaction.transaction()).round();
        Signature signature = new Signature(SignatureType.RSA, ((StateSignatureTransaction)scopedTransaction.transaction()).signature().toByteArray());
        this.signedStateMetrics.getStateSignaturesGatheredPerSecondMetric().cycle();
        if (this.lastStateRound != -1L) {
            long signatureAge = round - this.lastStateRound;
            this.signedStateMetrics.getStateSignatureAge().update((double)signatureAge);
        }
        if ((reservedState = this.incompleteStates.get(round)) == null) {
            this.savedSignatures.add((Object)new SavedSignature(round, scopedTransaction.submitterId(), signature));
            return null;
        }
        return this.addSignature(reservedState, scopedTransaction.submitterId(), signature);
    }

    @Override
    @Nullable
    public List<ReservedSignedState> handlePostconsensusSignatures(@NonNull Queue<ScopedSystemTransaction<StateSignatureTransaction>> transactions) {
        Objects.requireNonNull(transactions, "transactions");
        return transactions.stream().map(this::handlePostconsensusSignature).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), l -> l.isEmpty() ? null : l));
    }

    @Nullable
    private ReservedSignedState handlePostconsensusSignature(@NonNull ScopedSystemTransaction<StateSignatureTransaction> scopedTransaction) {
        long round = ((StateSignatureTransaction)scopedTransaction.transaction()).round();
        ReservedSignedState reservedState = this.incompleteStates.get(round);
        if (reservedState == null) {
            return null;
        }
        return this.addSignature(reservedState, scopedTransaction.submitterId(), new Signature(SignatureType.RSA, ((StateSignatureTransaction)scopedTransaction.transaction()).signature().toByteArray()));
    }

    @Nullable
    private ReservedSignedState addSignature(@NonNull ReservedSignedState reservedSignedState, @NonNull NodeId nodeId, @NonNull Signature signature) {
        SignedState signedState = reservedSignedState.get();
        if (signedState.addSignature(nodeId, signature)) {
            this.signedStateMetrics.getStatesSignedPerSecondMetric().cycle();
            this.signedStateMetrics.getAverageTimeToFullySignStateMetric().update((double)Duration.between(signedState.getCreationTimestamp(), Instant.now()).toMillis());
            return this.incompleteStates.remove(signedState.getRound());
        }
        return null;
    }

    private long getEarliestPermittedRound() {
        return this.lastStateRound - (long)this.stateConfig.roundsToKeepForSigning() + 1L;
    }

    @NonNull
    private List<ReservedSignedState> purgeOldStates() {
        ArrayList<ReservedSignedState> purgedStates = new ArrayList<ReservedSignedState>();
        long earliestPermittedRound = this.getEarliestPermittedRound();
        Iterator<ReservedSignedState> iterator = this.incompleteStates.values().iterator();
        while (iterator.hasNext()) {
            ReservedSignedState reservedSignedState = iterator.next();
            SignedState signedState = reservedSignedState.get();
            if (signedState.getRound() >= earliestPermittedRound) continue;
            this.signedStateMetrics.getTotalUnsignedStatesMetric().increment();
            purgedStates.add(reservedSignedState);
            iterator.remove();
        }
        this.signedStateMetrics.getUnsignedStatesMetric().update((double)this.incompleteStates.size());
        return purgedStates;
    }

    private void adjustSavedSignaturesWindow(long currentRound) {
        if (this.savedSignatures.getFirstSequenceNumberInWindow() < currentRound + 1L) {
            this.savedSignatures.shiftWindow(currentRound + 1L);
        }
    }

    @Override
    public void clear(@NonNull Object ignored) {
        Iterator<ReservedSignedState> iterator = this.incompleteStates.values().iterator();
        while (iterator.hasNext()) {
            ReservedSignedState state = iterator.next();
            state.close();
            iterator.remove();
        }
        this.savedSignatures.clear();
        this.lastStateRound = -1L;
    }

    private record SavedSignature(long round, @NonNull NodeId memberId, @NonNull Signature signature) {
    }
}

