/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.snapshot;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.streams.StreamDebugUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.state.service.schemas.V0540RosterBaseSchema;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.state.snapshot.SignedStateFileUtils;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;
import org.hiero.consensus.platformstate.V0540PlatformStateSchema;
import org.hiero.consensus.state.signed.SigSet;
import org.hiero.consensus.state.signed.SignedState;

public final class SignedStateFileReader {
    private SignedStateFileReader() {
    }

    @NonNull
    public static DeserializedSignedState readState(@NonNull Path stateDir, @NonNull PlatformContext platformContext, @NonNull StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager) throws IOException, ParseException {
        SigSet sigSet;
        Objects.requireNonNull(stateDir);
        Objects.requireNonNull(platformContext);
        Configuration conf = platformContext.getConfiguration();
        SignedStateFileReader.checkSignedStateFilePath(stateDir);
        VirtualMapState virtualMapState = (VirtualMapState)stateLifecycleManager.loadSnapshot(stateDir);
        File pbjFile = stateDir.resolve("signatureSet.pbj").toFile();
        if (pbjFile.exists()) {
            sigSet = new SigSet();
            try (ReadableStreamingData in2 = new ReadableStreamingData((InputStream)new FileInputStream(pbjFile));){
                sigSet.deserialize(in2);
            }
        } else {
            File sigSetFile = stateDir.resolve("signatureSet.bin").toFile();
            sigSet = (SigSet)StreamDebugUtils.deserializeAndDebugOnFailure(() -> new BufferedInputStream(new FileInputStream(sigSetFile)), in -> {
                SignedStateFileReader.readAndCheckSigSetFileVersion(in);
                return (SigSet)in.readSerializable();
            });
        }
        SignedState newSignedState = new SignedState(conf, ConsensusCryptoUtils::verifySignature, virtualMapState, "SignedStateFileReader.readState()", false, false, false);
        SignedStateFileReader.registerServiceStates(newSignedState);
        newSignedState.setSigSet(sigSet);
        DeserializedSignedState returnState = new DeserializedSignedState(newSignedState.reserve("SignedStateFileReader.readState()"), virtualMapState.getHash());
        return returnState;
    }

    private static void checkSignedStateFilePath(@NonNull Path stateDirectory) throws IOException {
        Path signedStatePbjPath = stateDirectory.resolve("signatureSet.pbj");
        Path signedStateBinPath = stateDirectory.resolve("signatureSet.bin");
        if (!Files.exists(signedStatePbjPath, new LinkOption[0]) && !Files.exists(signedStateBinPath, new LinkOption[0])) {
            throw new IOException("Directory " + String.valueOf(stateDirectory.toAbsolutePath()) + " does not contain a signature set!");
        }
    }

    private static void readAndCheckSigSetFileVersion(@NonNull SerializableDataInputStream in) throws IOException {
        int fileVersion = in.readInt();
        if (!SignedStateFileUtils.SUPPORTED_SIGSET_VERSIONS.contains(fileVersion)) {
            throw new IOException("Unsupported file version: " + fileVersion);
        }
        in.readProtocolVersion();
    }

    public static void registerServiceStates(@NonNull SignedState signedState) {
        SignedStateFileReader.registerServiceStates(signedState.getState());
    }

    public static void registerServiceStates(@NonNull VirtualMapState state) {
        SignedStateFileReader.registerServiceState(state, (Schema<SemanticVersion>)new V0540PlatformStateSchema(), "PlatformStateService");
        SignedStateFileReader.registerServiceState(state, new V0540RosterBaseSchema(), "RosterService");
    }

    private static void registerServiceState(@NonNull VirtualMapState state, @NonNull Schema<SemanticVersion> schema, @NonNull String name) {
        schema.statesToCreate().stream().sorted(Comparator.comparing(StateDefinition::stateKey)).forEach(def -> {
            StateMetadata md = new StateMetadata(name, def);
            if (!def.singleton() && !def.keyValue()) {
                throw new IllegalStateException("Only singletons and keyValue virtual maps are supported as stub states");
            }
            state.initializeState(md);
        });
    }
}

