/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli.recovery;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.JudgeId;
import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.hedera.pbj.runtime.ParseException;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.notification.Listener;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.common.stream.RunningHashCalculatorForStream;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.eventhandling.DefaultTransactionPrehandler;
import com.swirlds.platform.recovery.internal.EventStreamRoundIterator;
import com.swirlds.platform.recovery.internal.StreamedRound;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.snapshot.DeserializedSignedState;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.platform.state.snapshot.SignedStateFileWriter;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.system.state.notifications.NewRecoveredStateListener;
import com.swirlds.platform.system.state.notifications.NewRecoveredStateNotification;
import com.swirlds.platform.util.BootstrapUtils;
import com.swirlds.platform.util.HederaUtils;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.StateLifecycleManagerImpl;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.merkle.VirtualMapStateImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.LongStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.RunningHashable;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;
import org.hiero.consensus.crypto.DefaultEventHasher;
import org.hiero.consensus.hashgraph.config.ConsensusConfig;
import org.hiero.consensus.hashgraph.impl.consensus.ConsensusUtils;
import org.hiero.consensus.io.IOIterator;
import org.hiero.consensus.model.PbjConverters;
import org.hiero.consensus.model.event.CesEvent;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.notification.Notification;
import org.hiero.consensus.pces.config.PcesConfig;
import org.hiero.consensus.pces.config.PcesFileWriterType;
import org.hiero.consensus.pces.impl.common.PcesFile;
import org.hiero.consensus.pces.impl.common.PcesMutableFile;
import org.hiero.consensus.pcli.recovery.RecoveredState;
import org.hiero.consensus.pcli.recovery.RecoveryPlatform;
import org.hiero.consensus.platformstate.PlatformStateUtils;
import org.hiero.consensus.round.RoundCalculationUtils;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;

public final class EventRecoveryWorkflow {
    private static final Logger logger = LogManager.getLogger(EventRecoveryWorkflow.class);

    private EventRecoveryWorkflow() {
    }

    public static void recoverState(@NonNull PlatformContext platformContext, @NonNull Path signedStateDir, @NonNull Path eventStreamDirectory, @NonNull Boolean allowPartialRounds, @NonNull Long finalRound, @NonNull Path resultingStateDirectory, @NonNull NodeId selfId, boolean loadSigningKeys) throws IOException, ParseException {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(signedStateDir, "signedStateDir must not be null");
        Objects.requireNonNull(eventStreamDirectory, "eventStreamDirectory must not be null");
        Objects.requireNonNull(allowPartialRounds, "allowPartialRounds must not be null");
        Objects.requireNonNull(finalRound, "finalRound must not be null");
        Objects.requireNonNull(resultingStateDirectory, "resultingStateDirectory must not be null");
        Objects.requireNonNull(selfId, "selfId must not be null");
        BootstrapUtils.setupConstructableRegistry();
        if (!Files.exists(resultingStateDirectory, new LinkOption[0])) {
            Files.createDirectories(resultingStateDirectory, new FileAttribute[0]);
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Loading state from {}", (Object)signedStateDir);
        SwirldMain hederaApp = HederaUtils.createHederaAppMain((PlatformContext)platformContext);
        StateLifecycleManagerImpl stateLifecycleManager = new StateLifecycleManagerImpl(platformContext.getMetrics(), platformContext.getTime(), virtualMap -> new VirtualMapStateImpl(virtualMap, platformContext.getMetrics()), platformContext.getConfiguration());
        DeserializedSignedState deserializedSignedState = SignedStateFileReader.readState((Path)signedStateDir, (PlatformContext)platformContext, (StateLifecycleManager)stateLifecycleManager);
        try (ReservedSignedState initialState = deserializedSignedState.reservedSignedState();){
            HederaUtils.updateStateHash((SwirldMain)hederaApp, (DeserializedSignedState)deserializedSignedState);
            logger.info(LogMarker.STARTUP.getMarker(), "State from round {} loaded.", (Object)initialState.get().getRound());
            logger.info(LogMarker.STARTUP.getMarker(), "Loading event stream at {}", (Object)eventStreamDirectory);
            EventStreamRoundIterator roundIterator = new EventStreamRoundIterator(initialState.get().getRoster(), eventStreamDirectory, initialState.get().getRound() + 1L, allowPartialRounds.booleanValue());
            logger.info(LogMarker.STARTUP.getMarker(), "Reapplying transactions");
            RecoveredState recoveredState = EventRecoveryWorkflow.reapplyTransactions(platformContext, initialState.getAndReserve("recoverState()"), hederaApp, (IOIterator<StreamedRound>)roundIterator, finalRound, selfId, loadSigningKeys);
            logger.info(LogMarker.STARTUP.getMarker(), "Finished reapplying transactions, writing state to {}", (Object)resultingStateDirectory);
            VirtualMapState mutableStateCopy = recoveredState.state().get().getState().copy();
            SignedStateFileWriter.writeSignedStateFilesToDirectory((PlatformContext)platformContext, (NodeId)selfId, (Path)resultingStateDirectory, (SignedState)recoveredState.state().get(), (StateLifecycleManager)stateLifecycleManager);
            logger.info(LogMarker.STARTUP.getMarker(), "Signed state written to disk");
            PcesFile preconsensusEventFile = PcesFile.of((Instant)Instant.now(), (long)0L, (long)recoveredState.judge().getBirthRound(), (long)recoveredState.judge().getBirthRound(), (long)recoveredState.state().get().getRound(), (Path)resultingStateDirectory);
            PcesFileWriterType type = ((PcesConfig)platformContext.getConfiguration().getConfigData(PcesConfig.class)).pcesFileWriterType();
            PcesMutableFile mutableFile = preconsensusEventFile.getMutableFile(type);
            mutableFile.writeEvent(recoveredState.judge());
            mutableFile.close();
            recoveredState.state().close();
            mutableStateCopy.release();
            logger.info(LogMarker.STARTUP.getMarker(), "Recovery process completed");
        }
    }

    private static void notifyStateRecovered(NotificationEngine notificationEngine, SignedState recoveredState) {
        NewRecoveredStateNotification notification = new NewRecoveredStateNotification(recoveredState.getState(), recoveredState.getRound(), recoveredState.getConsensusTimestamp());
        notificationEngine.dispatch(NewRecoveredStateListener.class, (Notification)notification);
    }

    @NonNull
    public static RecoveredState reapplyTransactions(@NonNull PlatformContext platformContext, @NonNull ReservedSignedState initialSignedState, @NonNull SwirldMain appMain, @NonNull IOIterator<StreamedRound> roundIterator, long finalRound, @NonNull NodeId selfId, boolean loadSigningKeys) throws IOException {
        Objects.requireNonNull(platformContext, "platformContext must not be null");
        Objects.requireNonNull(initialSignedState, "initialSignedState must not be null");
        Objects.requireNonNull(appMain, "appMain must not be null");
        Objects.requireNonNull(roundIterator, "roundIterator must not be null");
        Objects.requireNonNull(selfId, "selfId must not be null");
        Configuration configuration = platformContext.getConfiguration();
        ReservedSignedState workingSignedState = EventRecoveryWorkflow.ensureMutableState(initialSignedState, configuration);
        VirtualMapState initialState = workingSignedState.get().getState();
        initialState.throwIfImmutable("initial state must be mutable");
        logger.info(LogMarker.STARTUP.getMarker(), "Initializing application state");
        RecoveryPlatform platform = new RecoveryPlatform(configuration, workingSignedState.get(), selfId, loadSigningKeys);
        ConsensusStateEventHandler consensusStateEventHandler = appMain.newConsensusStateEvenHandler();
        SemanticVersion softwareVersion = PlatformStateUtils.creationSoftwareVersionOf((State)initialState);
        NotificationEngine notificationEngine = platform.getNotificationEngine();
        notificationEngine.register(NewRecoveredStateListener.class, (Listener)((NewRecoveredStateListener)notification -> consensusStateEventHandler.onNewRecoveredState((State)notification.getState())));
        consensusStateEventHandler.onStateInitialized((State)initialState, (Platform)platform, InitTrigger.EVENT_STREAM_RECOVERY, softwareVersion);
        appMain.init((Platform)platform, platform.getSelfId());
        ReservedSignedState signedState = workingSignedState;
        ConsensusEvent lastEvent = null;
        while (roundIterator.hasNext() && (finalRound == -1L || ((StreamedRound)roundIterator.peek()).getRoundNum() <= finalRound)) {
            StreamedRound round = (StreamedRound)roundIterator.next();
            logger.info(LogMarker.STARTUP.getMarker(), "Applying {} events from round {}", (Object)round.getEventCount(), (Object)round.getRoundNum());
            signedState = EventRecoveryWorkflow.handleNextRound(consensusStateEventHandler, platformContext, signedState, round);
            platform.setLatestState(signedState.get());
            lastEvent = EventRecoveryWorkflow.getLastEvent((Round)round);
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Hashing resulting signed state");
        signedState.get().getState().getHash();
        logger.info(LogMarker.STARTUP.getMarker(), "Hashing complete");
        EventRecoveryWorkflow.notifyStateRecovered(platform.getNotificationEngine(), signedState.get());
        platform.close();
        return new RecoveredState(signedState, ((CesEvent)Objects.requireNonNull(lastEvent)).getPlatformEvent());
    }

    private static ReservedSignedState ensureMutableState(@NonNull ReservedSignedState initialSignedState, @NonNull Configuration configuration) {
        SignedState signedState = initialSignedState.get();
        VirtualMapState state = signedState.getState();
        if (!state.isHashed()) {
            return initialSignedState;
        }
        VirtualMapState mutableState = state.copy();
        SignedState mutableSignedState = new SignedState(configuration, ConsensusCryptoUtils::verifySignature, mutableState, "EventRecoveryWorkflow.ensureMutableState()", signedState.isFreezeState(), false, signedState.isPcesRound());
        mutableSignedState.setSigSet(signedState.getSigSet().copy());
        initialSignedState.close();
        return mutableSignedState.reserve("EventRecoveryWorkflow.ensureMutableState()");
    }

    private static ReservedSignedState handleNextRound(@NonNull ConsensusStateEventHandler consensusStateEventHandler, @NonNull PlatformContext platformContext, @NonNull ReservedSignedState previousSignedState, @NonNull StreamedRound round) {
        Instant currentRoundTimestamp = EventRecoveryWorkflow.getRoundTimestamp((Round)round);
        SignedState previousState = previousSignedState.get();
        previousState.getState().throwIfImmutable();
        VirtualMapState newState = previousState.getState().copy();
        PlatformEvent lastEvent = ((CesEvent)EventRecoveryWorkflow.getLastEvent((Round)round)).getPlatformEvent();
        ConsensusConfig config = (ConsensusConfig)platformContext.getConfiguration().getConfigData(ConsensusConfig.class);
        new DefaultEventHasher().hashEvent(lastEvent);
        PlatformStateUtils.bulkUpdateOf((State)newState, v -> {
            v.setRound(round.getRoundNum());
            v.setLegacyRunningEventHash(EventRecoveryWorkflow.getHashEventsCons(PlatformStateUtils.legacyRunningEventHashOf((State)newState), round));
            v.setConsensusTimestamp(currentRoundTimestamp);
            v.setSnapshot(EventRecoveryWorkflow.generateSyntheticSnapshot(round.getRoundNum(), lastEvent.getConsensusOrder(), currentRoundTimestamp, config, lastEvent));
            v.setCreationSoftwareVersion(PlatformStateUtils.creationSoftwareVersionOf((State)previousState.getState()));
        });
        EventRecoveryWorkflow.applyTransactions(consensusStateEventHandler, previousState.getState(), newState, (Round)round);
        boolean isFreezeState = EventRecoveryWorkflow.isFreezeState(previousState.getConsensusTimestamp(), currentRoundTimestamp, PlatformStateUtils.freezeTimeOf((State)newState));
        if (isFreezeState) {
            PlatformStateUtils.updateLastFrozenTime((State)newState);
        }
        SignedState signedState = new SignedState(platformContext.getConfiguration(), ConsensusCryptoUtils::verifySignature, newState, "EventRecoveryWorkflow.handleNextRound()", isFreezeState, false, false);
        ReservedSignedState reservedSignedState = signedState.reserve("recovery");
        previousSignedState.close();
        return reservedSignedState;
    }

    static Hash getHashEventsCons(Hash previousRunningHash, StreamedRound round) {
        RunningHashCalculatorForStream hashCalculator = new RunningHashCalculatorForStream();
        hashCalculator.setRunningHash(previousRunningHash);
        for (ConsensusEvent event : round) {
            hashCalculator.addObject((RunningHashable)((CesEvent)event));
        }
        Hash runningHash = hashCalculator.getRunningHash();
        hashCalculator.close();
        return runningHash;
    }

    static Instant getRoundTimestamp(Round round) {
        return EventRecoveryWorkflow.getLastEvent(round).getConsensusTimestamp();
    }

    static ConsensusEvent getLastEvent(Round round) {
        Iterator iterator = round.iterator();
        while (iterator.hasNext()) {
            ConsensusEvent event = (ConsensusEvent)iterator.next();
            if (iterator.hasNext()) continue;
            return event;
        }
        throw new IllegalStateException("round has no events");
    }

    static void applyTransactions(ConsensusStateEventHandler consensusStateEventHandler, VirtualMapState immutableState, VirtualMapState mutableState, Round round) {
        mutableState.throwIfImmutable();
        for (ConsensusEvent event : round) {
            consensusStateEventHandler.onPreHandle((Event)event, (State)immutableState, DefaultTransactionPrehandler.NO_OP_CONSUMER);
        }
        consensusStateEventHandler.onHandleConsensusRound(round, (State)mutableState, DefaultTransactionPrehandler.NO_OP_CONSUMER);
    }

    static boolean isFreezeState(Instant previousRoundTimestamp, Instant currentRoundTimestamp, Instant freezeTime) {
        if (freezeTime == null) {
            return false;
        }
        return CompareTo.isLessThan((Comparable)previousRoundTimestamp, (Object)freezeTime) && CompareTo.isGreaterThanOrEqualTo((Comparable)currentRoundTimestamp, (Object)freezeTime);
    }

    @NonNull
    private static ConsensusSnapshot generateSyntheticSnapshot(long round, long lastConsensusOrder, @NonNull Instant roundTimestamp, @NonNull ConsensusConfig config, @NonNull PlatformEvent judge) {
        List<MinimumJudgeInfo> minimumJudgeInfos = LongStream.range(RoundCalculationUtils.getOldestNonAncientRound((int)config.roundsNonAncient(), (long)round), round + 1L).mapToObj(r -> new MinimumJudgeInfo(r, judge.getBirthRound())).toList();
        return ConsensusSnapshot.newBuilder().round(round).judgeIds(List.of(JudgeId.newBuilder().creatorId(judge.getCreatorId().id()).judgeHash(judge.getHash().getBytes()).build())).minimumJudgeInfoList(minimumJudgeInfos).nextConsensusNumber(lastConsensusOrder + 1L).consensusTimestamp(PbjConverters.toPbjTimestamp((Instant)ConsensusUtils.calcMinTimestampForNextEvent((Instant)roundTimestamp))).build();
    }
}

