/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.noop;

import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hiero.consensus.metrics.PlatformMetrics;
import org.hiero.consensus.metrics.noop.internal.NoOpMetricsFactory;
import org.hiero.consensus.model.node.NodeId;

@Deprecated(forRemoval=true)
public class NoOpMetrics
implements PlatformMetrics {
    private final Map<String, Map<String, Metric>> metrics = new HashMap<String, Map<String, Metric>>();
    private static final NoOpMetricsFactory FACTORY = new NoOpMetricsFactory();

    @Override
    public NodeId getNodeId() {
        return NodeId.of((long)42L);
    }

    @Override
    public boolean isGlobalMetrics() {
        return false;
    }

    @Override
    public boolean isPlatformMetrics() {
        return true;
    }

    @Nullable
    public synchronized Metric getMetric(@NonNull String category, @NonNull String name) {
        Map<String, Metric> metricsInCategory = this.metrics.get(category);
        if (metricsInCategory == null) {
            return null;
        }
        return metricsInCategory.get(name);
    }

    @NonNull
    public synchronized Collection<Metric> findMetricsByCategory(@NonNull String category) {
        Map<String, Metric> metricsInCategory = this.metrics.get(category);
        if (metricsInCategory == null) {
            return List.of();
        }
        return metricsInCategory.values();
    }

    @NonNull
    public synchronized Collection<Metric> getAll() {
        ArrayList<Metric> allMetrics = new ArrayList<Metric>();
        for (Map<String, Metric> metricsInCategory : this.metrics.values()) {
            allMetrics.addAll(metricsInCategory.values());
        }
        return allMetrics;
    }

    @NonNull
    public synchronized <T extends Metric> T getOrCreate(@NonNull MetricConfig<T, ?> config) {
        Objects.requireNonNull(config, "config must not be null");
        String category = config.getCategory();
        String name = config.getName();
        Map metricsInCategory = this.metrics.computeIfAbsent(category, k -> new HashMap());
        return (T)metricsInCategory.computeIfAbsent(name, k -> FACTORY.createMetric(config));
    }

    public synchronized void remove(@NonNull String category, @NonNull String name) {
        Objects.requireNonNull(category, "category must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Map<String, Metric> metricsInCategory = this.metrics.get(category);
        if (metricsInCategory == null) {
            return;
        }
        metricsInCategory.remove(name);
        if (metricsInCategory.isEmpty()) {
            this.metrics.remove(category);
        }
    }

    public void remove(@NonNull Metric metric) {
        Objects.requireNonNull(metric, "metric must not be null");
        this.remove(metric.getCategory(), metric.getName());
    }

    public void remove(@NonNull MetricConfig<?, ?> config) {
        Objects.requireNonNull(config, "config must not be null");
        this.remove(config.getCategory(), config.getName());
    }

    public void addUpdater(@NonNull Runnable updater) {
        Objects.requireNonNull(updater, "updater must not be null");
    }

    public void removeUpdater(@NonNull Runnable updater) {
        Objects.requireNonNull(updater, "updater must not be null");
    }

    public void start() {
    }
}

