/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.reconnect.impl;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.stream.RunningEventHashOverride;
import com.swirlds.component.framework.wires.input.NoInput;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.components.AppNotifier;
import com.swirlds.platform.event.branching.BranchDetector;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.listeners.ReconnectCompleteNotification;
import com.swirlds.platform.state.nexus.SignedStateNexus;
import com.swirlds.platform.state.signed.StateSignatureCollector;
import com.swirlds.platform.wiring.PlatformComponents;
import com.swirlds.platform.wiring.PlatformCoordinator;
import com.swirlds.state.State;
import com.swirlds.state.merkle.VirtualMapState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.hashgraph.config.ConsensusConfig;
import org.hiero.consensus.model.status.PlatformStatusAction;
import org.hiero.consensus.platformstate.PlatformStateUtils;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.roster.RosterStateUtils;
import org.hiero.consensus.round.EventWindowUtils;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;

public class ReconnectCoordinator {
    private final PlatformComponents components;
    private final PlatformCoordinator platformCoordinator;

    public ReconnectCoordinator(@NonNull PlatformComponents components, @NonNull PlatformCoordinator platformCoordinator) {
        this.components = Objects.requireNonNull(components);
        this.platformCoordinator = Objects.requireNonNull(platformCoordinator);
    }

    public void submitStatusAction(@NonNull PlatformStatusAction action) {
        this.platformCoordinator.submitStatusAction(action);
    }

    public void clear() {
        this.components.platformMonitorWiring().flush();
        this.components.hashgraphModule().startSquelching();
        this.components.hashgraphModule().flush();
        this.components.eventCreatorModule().startSquelching();
        this.components.eventCreatorModule().flush();
        this.components.transactionHandlerWiring().startSquelching();
        this.components.transactionHandlerWiring().flush();
        this.platformCoordinator.flushIntakePipeline();
        this.components.stateHasherWiring().flush();
        this.components.stateSignatureCollectorWiring().flush();
        this.components.transactionHandlerWiring().flush();
        this.components.branchDetectorWiring().flush();
        this.components.branchReporterWiring().flush();
        this.components.hashgraphModule().stopSquelching();
        this.components.eventCreatorModule().stopSquelching();
        this.components.transactionHandlerWiring().stopSquelching();
        this.components.eventIntakeModule().clearComponentsInputWire().inject((Object)NoInput.getInstance());
        this.components.gossipModule().clearInputWire().inject((Object)NoInput.getInstance());
        this.components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::clear).inject((Object)NoInput.getInstance());
        this.components.eventCreatorModule().clearCreationMangerInputWire().inject((Object)NoInput.getInstance());
        this.components.branchDetectorWiring().getInputWire(BranchDetector::clear).inject((Object)NoInput.getInstance());
        this.components.branchReporterWiring().getInputWire(BranchReporter::clear).inject((Object)NoInput.getInstance());
    }

    public void resumeGossip() {
        this.components.gossipModule().resumeInputWire().inject((Object)NoInput.getInstance());
    }

    public void pauseGossip() {
        this.components.gossipModule().pauseInputWire().inject((Object)NoInput.getInstance());
    }

    public void sendReconnectCompleteNotification(@NonNull SignedState signedState) {
        this.components.notifierWiring().getInputWire(AppNotifier::sendReconnectCompleteNotification).put((Object)new ReconnectCompleteNotification(signedState.getRound(), signedState.getConsensusTimestamp(), (State)signedState.getState()));
    }

    public void loadReconnectState(@NonNull Configuration configuration, @NonNull SignedState signedState) {
        this.platformCoordinator.overrideIssDetectorState(signedState.reserve("reconnect state to issDetector"));
        this.components.latestImmutableStateNexusWiring().getInputWire(SignedStateNexus::setState).put((Object)signedState.reserve("set latest immutable to reconnect state"));
        this.platformCoordinator.sendStateToHashLogger(signedState);
        this.putSignatureCollectorState(signedState.reserve("loading reconnect state into sig collector"));
        VirtualMapState state = signedState.getState();
        ConsensusSnapshot consensusSnapshot = Objects.requireNonNull(PlatformStateUtils.consensusSnapshotOf((State)state));
        this.platformCoordinator.consensusSnapshotOverride(consensusSnapshot);
        RosterHistory rosterHistory = RosterStateUtils.createRosterHistory((State)state);
        this.injectRosterHistory(rosterHistory);
        int roundsNonAncient = ((ConsensusConfig)configuration.getConfigData(ConsensusConfig.class)).roundsNonAncient();
        this.platformCoordinator.updateEventWindow(EventWindowUtils.createEventWindow((ConsensusSnapshot)consensusSnapshot, (int)roundsNonAncient));
        RunningEventHashOverride runningEventHashOverride = new RunningEventHashOverride(PlatformStateUtils.legacyRunningEventHashOf((State)state), true);
        this.platformCoordinator.updateRunningHash(runningEventHashOverride);
        this.registerPcesDiscontinuity(signedState.getRound());
    }

    private void putSignatureCollectorState(@NonNull ReservedSignedState reserve) {
        this.components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::addReservedState).put((Object)reserve);
    }

    private void injectRosterHistory(@NonNull RosterHistory rosterHistory) {
        this.components.eventIntakeModule().rosterHistoryInputWire().inject((Object)rosterHistory);
    }

    private void registerPcesDiscontinuity(long round) {
        this.components.pcesModule().discontinuityInputWire().inject((Object)round);
    }
}

