/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.hashgraph.impl;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.base.time.Time;
import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.hiero.consensus.hashgraph.FreezePeriodChecker;
import org.hiero.consensus.hashgraph.HashgraphModule;
import org.hiero.consensus.hashgraph.config.HashgraphWiringConfig;
import org.hiero.consensus.hashgraph.impl.ConsensusEngine;
import org.hiero.consensus.hashgraph.impl.ConsensusEngineOutput;
import org.hiero.consensus.hashgraph.impl.DefaultConsensusEngine;
import org.hiero.consensus.metrics.statistics.EventPipelineTracker;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class DefaultHashgraphModule
implements HashgraphModule {
    @Nullable
    private ComponentWiring<ConsensusEngine, ConsensusEngineOutput> consensusEngineWiring;
    @Nullable
    private OutputWire<ConsensusRound> consensusRoundOutputWire;
    @Nullable
    private OutputWire<PlatformEvent> preconsensusEventOutputWire;
    @Nullable
    private OutputWire<PlatformEvent> staleEventOutputWire;

    public void initialize(@NonNull WiringModel model, @NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull FreezePeriodChecker freezeChecker, @Nullable EventPipelineTracker pipelineTracker) {
        if (this.consensusEngineWiring != null) {
            throw new IllegalStateException("Already initialized");
        }
        HashgraphWiringConfig wiringConfig = (HashgraphWiringConfig)configuration.getConfigData(HashgraphWiringConfig.class);
        this.consensusEngineWiring = new ComponentWiring(model, ConsensusEngine.class, wiringConfig.consensusEngine());
        this.consensusRoundOutputWire = this.consensusEngineWiring.getOutputWire().buildTransformer("consensusRounds", "consensusEngineOutput", ConsensusEngineOutput::consensusRounds).buildSplitter("ConsensusRoundsSplitter", "consensus rounds");
        this.preconsensusEventOutputWire = this.consensusEngineWiring.getOutputWire().buildTransformer("PreConsensusEvents", "consensusEngineOutput", ConsensusEngineOutput::preConsensusEvents).buildSplitter("PreConsensusEventsSplitter", "preconsensus events");
        this.staleEventOutputWire = this.consensusEngineWiring.getOutputWire().buildTransformer("staleEvents", "consensusEngineOutput", ConsensusEngineOutput::staleEvents).buildSplitter("staleEventsSplitter", "stale events");
        this.consensusEngineWiring.getInputWire(ConsensusEngine::outOfBandSnapshotUpdate);
        DefaultConsensusEngine consensusEngine = new DefaultConsensusEngine(configuration, metrics, time, roster, selfId, freezeChecker);
        this.consensusEngineWiring.bind((Object)consensusEngine);
        if (pipelineTracker != null) {
            pipelineTracker.registerMetric("consensus");
            this.consensusRoundOutputWire.solderForMonitoring(consensusRound -> pipelineTracker.recordEvents("consensus", consensusRound.getConsensusEvents().stream().map(PlatformEvent::getTimeReceived).toList()));
        }
    }

    @NonNull
    public InputWire<PlatformEvent> eventInputWire() {
        return Objects.requireNonNull(this.consensusEngineWiring, "Not initialized").getInputWire(ConsensusEngine::addEvent);
    }

    @NonNull
    public OutputWire<ConsensusRound> consensusRoundOutputWire() {
        return Objects.requireNonNull(this.consensusRoundOutputWire, "Not initialized");
    }

    @NonNull
    public OutputWire<PlatformEvent> preconsensusEventOutputWire() {
        return Objects.requireNonNull(this.preconsensusEventOutputWire, "Not initialized");
    }

    @NonNull
    public OutputWire<PlatformEvent> staleEventOutputWire() {
        return Objects.requireNonNull(this.staleEventOutputWire, "Not initialized");
    }

    @NonNull
    public InputWire<PlatformStatus> platformStatusInputWire() {
        return Objects.requireNonNull(this.consensusEngineWiring, "Not initialized").getInputWire(ConsensusEngine::updatePlatformStatus);
    }

    @NonNull
    public InputWire<ConsensusSnapshot> consensusSnapshotInputWire() {
        return Objects.requireNonNull(this.consensusEngineWiring, "Not initialized").getInputWire(ConsensusEngine::outOfBandSnapshotUpdate);
    }

    public void startSquelching() {
        Objects.requireNonNull(this.consensusEngineWiring, "Not initialized").startSquelching();
    }

    public void stopSquelching() {
        Objects.requireNonNull(this.consensusEngineWiring, "Not initialized").stopSquelching();
    }

    public void flush() {
        Objects.requireNonNull(this.consensusEngineWiring, "Not initialized").flush();
    }
}

