/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.hashgraph.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.hashgraph.FreezePeriodChecker;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;

public class FreezeRoundController {
    private final FreezePeriodChecker freezeChecker;
    private boolean isFrozen = false;

    public FreezeRoundController(@NonNull FreezePeriodChecker freezeChecker) {
        this.freezeChecker = Objects.requireNonNull(freezeChecker);
    }

    public List<ConsensusRound> filterAndModify(@NonNull List<ConsensusRound> consensusRounds) {
        if (consensusRounds.stream().map(ConsensusRound::getConsensusTimestamp).noneMatch(arg_0 -> ((FreezePeriodChecker)this.freezeChecker).isInFreezePeriod(arg_0))) {
            return consensusRounds;
        }
        this.isFrozen = true;
        ArrayList<ConsensusRound> modifiedRounds = new ArrayList<ConsensusRound>();
        for (ConsensusRound round : consensusRounds) {
            if (this.freezeChecker.isInFreezePeriod(round.getConsensusTimestamp())) {
                modifiedRounds.add(FreezeRoundController.modifyFreezeRound(round));
                return modifiedRounds;
            }
            modifiedRounds.add(round);
        }
        return modifiedRounds;
    }

    private static ConsensusRound modifyFreezeRound(@NonNull ConsensusRound round) {
        EventWindow modifiedWindow = new EventWindow(round.getEventWindow().latestConsensusRound(), round.getEventWindow().latestConsensusRound(), round.getEventWindow().ancientThreshold(), round.getEventWindow().expiredThreshold());
        return new ConsensusRound(round.getConsensusRoster(), round.getConsensusEvents(), modifiedWindow, round.getSnapshot(), round.isPcesRound(), round.getReachedConsTimestamp());
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }
}

