/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.hashgraph.impl.consensus;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.hiero.consensus.hashgraph.impl.EventImpl;
import org.hiero.consensus.model.event.EventDescriptorWrapper;

public class LocalConsensusGeneration {
    public static final int GENERATION_UNDEFINED = 0;
    public static final int FIRST_GENERATION = 1;
    private static final Consumer<EventImpl> CLEAR_CGEN = e -> e.setCGen(0);

    public static void assignCGen(@NonNull List<EventImpl> events) {
        Objects.requireNonNull(events);
        events.sort(Comparator.comparingLong(e -> e.getBaseEvent().getNGen()));
        HashMap<EventDescriptorWrapper, EventImpl> parentMap = new HashMap<EventDescriptorWrapper, EventImpl>();
        for (EventImpl event : events) {
            int maxParentGen = event.getBaseEvent().getAllParents().stream().map(parentMap::get).mapToInt(LocalConsensusGeneration::getGeneration).max().orElse(0);
            event.setCGen(maxParentGen == 0 ? 1 : maxParentGen + 1);
            parentMap.put(event.getBaseEvent().getDescriptor(), event);
        }
    }

    public static void clearCGen(@NonNull List<EventImpl> events) {
        Objects.requireNonNull(events);
        events.forEach(CLEAR_CGEN);
    }

    private static int getGeneration(@Nullable EventImpl event) {
        return event == null ? 0 : event.getCGen();
    }
}

