/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.health.entropy;

import com.swirlds.base.formatting.StringFormattingUtils;
import com.swirlds.platform.health.OSHealthCheckConfig;
import com.swirlds.platform.health.OSHealthCheckUtils;
import com.swirlds.platform.health.entropy.EntropySource;
import com.swirlds.platform.health.entropy.OSEntropyCheck;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class OSEntropyChecker {
    private OSEntropyChecker() {
    }

    public static boolean performEntropyChecks(StringBuilder sb, OSHealthCheckConfig osHealthCheckConfig) {
        return OSEntropyChecker.performEntropyChecks(sb, osHealthCheckConfig, List.of(EntropySource.strong(), EntropySource.of("NativePRNGBlocking", "SUN")));
    }

    private static boolean performEntropyChecks(StringBuilder sb, OSHealthCheckConfig osHealthCheckConfig, Iterable<EntropySource> entropySources) {
        boolean allPassed = true;
        for (EntropySource entropySource : entropySources) {
            allPassed &= OSEntropyChecker.performEntropyCheck(sb, osHealthCheckConfig, entropySource);
        }
        return allPassed;
    }

    private static boolean performEntropyCheck(StringBuilder sb, OSHealthCheckConfig osHealthConfig, EntropySource entropySource) {
        long maxGenNanos = TimeUnit.MILLISECONDS.toNanos(osHealthConfig.maxRandomNumberGenerationMillis());
        try {
            OSEntropyCheck.Report entropyReport = OSEntropyCheck.execute(osHealthConfig.entropyTimeoutMillis(), entropySource);
            return OSEntropyChecker.appendReport(sb, entropyReport, maxGenNanos);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while performing OS entropy check", e);
        }
    }

    private static boolean appendReport(StringBuilder sb, OSEntropyCheck.Report entropyReport, long maxGenNanos) {
        if (!entropyReport.success()) {
            OSHealthCheckUtils.reportHeader(sb, OSEntropyCheck.Report.name(), false);
            StringFormattingUtils.addLine((StringBuilder)sb, (String)"OS entropy check timed out.");
            return false;
        }
        if (entropyReport.elapsedNanos() > maxGenNanos) {
            OSHealthCheckUtils.reportHeader(sb, OSEntropyCheck.Report.name(), false);
            StringFormattingUtils.addLine((StringBuilder)sb, (String)String.format("OS random number generation (first call, not an average) is too slow. Maximum nanos allowed: %d, Took: %d", maxGenNanos, entropyReport.elapsedNanos()));
            return false;
        }
        OSHealthCheckUtils.reportHeader(sb, OSEntropyCheck.Report.name(), true);
        StringFormattingUtils.addLine((StringBuilder)sb, (String)entropyReport.toString());
        return true;
    }
}

