/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pces.impl.writer;

import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.pces.config.FileSyncOption;
import org.hiero.consensus.pces.config.PcesConfig;
import org.hiero.consensus.pces.impl.common.CommonPcesWriter;
import org.hiero.consensus.pces.impl.common.PcesFileManager;
import org.hiero.consensus.pces.impl.writer.InlinePcesWriter;
import org.hiero.consensus.pces.impl.writer.PcesWriterPerEventMetrics;

public class DefaultInlinePcesWriter
implements InlinePcesWriter {
    private final CommonPcesWriter commonPcesWriter;
    private final NodeId selfId;
    private final FileSyncOption fileSyncOption;
    private final PcesWriterPerEventMetrics pcesWriterPerEventMetrics;

    public DefaultInlinePcesWriter(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull PcesFileManager fileManager, @NonNull NodeId selfId) {
        Objects.requireNonNull(fileManager, "fileManager is required");
        this.commonPcesWriter = new CommonPcesWriter(configuration, fileManager);
        this.selfId = Objects.requireNonNull(selfId, "selfId is required");
        this.fileSyncOption = ((PcesConfig)configuration.getConfigData(PcesConfig.class)).inlinePcesSyncOption();
        this.pcesWriterPerEventMetrics = new PcesWriterPerEventMetrics(metrics, time);
    }

    @Override
    public void beginStreamingNewEvents() {
        this.commonPcesWriter.beginStreamingNewEvents();
    }

    @Override
    @NonNull
    public PlatformEvent writeEvent(@NonNull PlatformEvent event) {
        this.pcesWriterPerEventMetrics.startWriteEvent();
        if (!this.commonPcesWriter.isStreamingNewEvents()) {
            return event;
        }
        if (event.getBirthRound() < this.commonPcesWriter.getNonAncientBoundary()) {
            return event;
        }
        try {
            this.commonPcesWriter.prepareOutputStream(event);
            this.pcesWriterPerEventMetrics.startFileWrite();
            long size = this.commonPcesWriter.getCurrentMutableFile().writeEvent(event);
            this.pcesWriterPerEventMetrics.endFileWrite(size);
            if (this.fileSyncOption == FileSyncOption.EVERY_EVENT || this.fileSyncOption == FileSyncOption.EVERY_SELF_EVENT && event.getCreatorId().equals((Object)this.selfId)) {
                this.pcesWriterPerEventMetrics.startFileSync();
                this.commonPcesWriter.getCurrentMutableFile().sync();
                this.pcesWriterPerEventMetrics.endFileSync();
            }
            PlatformEvent platformEvent = event;
            return platformEvent;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.pcesWriterPerEventMetrics.endWriteEvent();
            this.pcesWriterPerEventMetrics.clear();
        }
    }

    @Override
    public void registerDiscontinuity(@NonNull Long newOriginRound) {
        this.commonPcesWriter.registerDiscontinuity(newOriginRound);
    }

    @Override
    public void updateNonAncientEventBoundary(@NonNull EventWindow nonAncientBoundary) {
        this.commonPcesWriter.updateNonAncientEventBoundary(nonAncientBoundary);
    }

    @Override
    public void setMinimumBirthRoundToStore(@NonNull Long minimumBirthRoundToStore) {
        this.commonPcesWriter.setMinimumBirthRoundToStore(minimumBirthRoundToStore);
    }
}

