/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.helidon;

import com.hedera.pbj.grpc.helidon.PbjGrpcServiceConfig;
import com.hedera.pbj.grpc.helidon.PbjRoute;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Metrics;
import io.helidon.metrics.api.Tag;
import java.util.Objects;

final class PbjMethodRoute
extends PbjRoute {
    private static final String SEP = "/";
    @NonNull
    private final ServiceInterface service;
    @NonNull
    private final PbjGrpcServiceConfig serviceConfig;
    @NonNull
    private final ServiceInterface.Method method;
    @NonNull
    private final String fullPath;
    @NonNull
    private final PathMatcher pathMatcher;
    private static final String SCOPE = "vendor";
    private static final String SERVICE_TAG = "service";
    private static final String METHOD_TAG = "method";
    private static final String FAILURE_TAG = "failure";
    @NonNull
    private final Counter requestCounter;
    @NonNull
    private final Counter failedGrpcRequestCounter;
    @NonNull
    private final Counter failedHttpRequestCounter;
    @NonNull
    private final Counter failedUnknownRequestCounter;
    @NonNull
    private final Counter failedResponseCounter;
    @NonNull
    private final Counter deadlineExceededCounter;

    PbjMethodRoute(@NonNull ServiceInterface service, @NonNull PbjGrpcServiceConfig serviceConfig, @NonNull ServiceInterface.Method method) {
        this.service = Objects.requireNonNull(service);
        this.serviceConfig = Objects.requireNonNull(serviceConfig);
        this.method = Objects.requireNonNull(method);
        String serviceName = service.fullName();
        String methodName = method.name();
        this.fullPath = SEP + serviceName + SEP + methodName;
        this.pathMatcher = PathMatchers.exact((String)this.fullPath);
        MeterRegistry metricRegistry = Metrics.globalRegistry();
        this.requestCounter = (Counter)metricRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)"pbj.grpc.requests").scope(SCOPE)).addTag(Tag.create((String)SERVICE_TAG, (String)serviceName))).addTag(Tag.create((String)METHOD_TAG, (String)methodName))).description("The number of gRPC requests")));
        this.failedGrpcRequestCounter = (Counter)metricRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)"pbj.grpc.failed.requests").scope(SCOPE)).addTag(Tag.create((String)SERVICE_TAG, (String)serviceName))).addTag(Tag.create((String)METHOD_TAG, (String)methodName))).addTag(Tag.create((String)FAILURE_TAG, (String)"grpc-exception"))).description("The number of failed gRPC requests")));
        this.failedHttpRequestCounter = (Counter)metricRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)"pbj.grpc.failed.requests").scope(SCOPE)).addTag(Tag.create((String)SERVICE_TAG, (String)serviceName))).addTag(Tag.create((String)METHOD_TAG, (String)methodName))).addTag(Tag.create((String)FAILURE_TAG, (String)"http-exception"))).description("The number of failed HTTP requests")));
        this.failedUnknownRequestCounter = (Counter)metricRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)"pbj.grpc.failed.requests").scope(SCOPE)).addTag(Tag.create((String)SERVICE_TAG, (String)serviceName))).addTag(Tag.create((String)METHOD_TAG, (String)methodName))).addTag(Tag.create((String)FAILURE_TAG, (String)"unknown-exception"))).description("The number of failed unknown requests")));
        this.failedResponseCounter = (Counter)metricRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)"pbj.grpc.failed.responses").scope(SCOPE)).addTag(Tag.create((String)SERVICE_TAG, (String)serviceName))).addTag(Tag.create((String)METHOD_TAG, (String)methodName))).addTag(Tag.create((String)FAILURE_TAG, (String)"response"))).description("The number of failed responses")));
        this.deadlineExceededCounter = (Counter)metricRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)"pbj.grpc.deadline.exceeded").scope(SCOPE)).addTag(Tag.create((String)SERVICE_TAG, (String)serviceName))).addTag(Tag.create((String)METHOD_TAG, (String)methodName))).description("The number of gRPC requests that exceeded their deadline")));
    }

    @Override
    @NonNull
    PbjMethodRoute toPbjMethodRoute(@NonNull HttpPrologue grpcPrologue) {
        return this;
    }

    @Override
    @NonNull
    PathMatchers.MatchResult accepts(@NonNull HttpPrologue prologue) {
        return this.pathMatcher.match(prologue.uriPath());
    }

    @NonNull
    ServiceInterface.Method method() {
        return this.method;
    }

    @NonNull
    ServiceInterface service() {
        return this.service;
    }

    @NonNull
    PbjGrpcServiceConfig serviceConfig() {
        return this.serviceConfig;
    }

    @NonNull
    String fullPath() {
        return this.fullPath;
    }

    @NonNull
    public Counter requestCounter() {
        return this.requestCounter;
    }

    @NonNull
    public Counter failedGrpcRequestCounter() {
        return this.failedGrpcRequestCounter;
    }

    @NonNull
    public Counter failedHttpRequestCounter() {
        return this.failedHttpRequestCounter;
    }

    @NonNull
    public Counter failedUnknownRequestCounter() {
        return this.failedUnknownRequestCounter;
    }

    @NonNull
    public Counter failedResponseCounter() {
        return this.failedResponseCounter;
    }

    @NonNull
    public Counter deadlineExceededCounter() {
        return this.deadlineExceededCounter;
    }
}

