/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class MStoreOperation
extends AbstractOperation {
    public MStoreOperation(GasCalculator gasCalculator) {
        super(82, "MSTORE", 2, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long location = Words.clampedToLong(frame.popStackItem());
        Bytes value = frame.popStackItem();
        long cost = this.gasCalculator().mStoreOperationGasCost(frame, location);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        frame.writeMemoryRightAligned(location, 32L, value, true);
        return new Operation.OperationResult(cost, null);
    }
}

