/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.operation.Operation;

public class VirtualOperation
implements Operation {
    private final Operation delegate;

    public VirtualOperation(Operation delegate) {
        this.delegate = delegate;
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Operation.OperationResult result = this.delegate.execute(frame, evm);
        return new Operation.OperationResult(result.getGasCost(), result.getHaltReason(), 0);
    }

    @Override
    public int getOpcode() {
        return this.delegate.getOpcode();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public int getStackItemsConsumed() {
        return this.delegate.getStackItemsConsumed();
    }

    @Override
    public int getStackItemsProduced() {
        return this.delegate.getStackItemsProduced();
    }

    @Override
    public boolean isVirtualOperation() {
        return true;
    }
}

