/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.consensus.crypto.SigningFactory;

public class ConsensusCryptoUtils {
    private static final Logger logger = LogManager.getLogger();

    private ConsensusCryptoUtils() {
    }

    public static boolean verifySignature(@NonNull Bytes data, @NonNull Bytes signature, @NonNull PublicKey publicKey) {
        Objects.requireNonNull(data);
        Objects.requireNonNull(signature);
        Objects.requireNonNull(publicKey);
        try {
            return SigningFactory.createVerifier(publicKey).verify(data, signature);
        }
        catch (CryptographyException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception occurred while validating a signature:", (Throwable)e);
            return false;
        }
    }

    public static SecureRandom getNonDetRandom() {
        SecureRandom nonDetRandom;
        try {
            nonDetRandom = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException((Throwable)e, LogMarker.EXCEPTION);
        }
        nonDetRandom.nextBytes(new byte[1]);
        return nonDetRandom;
    }

    public static KeyStore createEmptyTrustStore() throws KeyStoreException {
        KeyStore trustStore;
        try {
            trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new CryptographyException((Throwable)e);
        }
        return trustStore;
    }
}

