/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.io.extendable.extensions;

import org.hiero.consensus.io.extendable.extensions.AbstractStreamExtension;
import org.hiero.consensus.io.extendable.extensions.internal.Counter;
import org.hiero.consensus.io.extendable.extensions.internal.StandardCounter;
import org.hiero.consensus.io.extendable.extensions.internal.ThreadSafeCounter;

public class CountingStreamExtension
extends AbstractStreamExtension {
    private final Counter counter;

    public CountingStreamExtension() {
        this(true);
    }

    public CountingStreamExtension(boolean threadSafe) {
        this.counter = threadSafe ? new ThreadSafeCounter() : new StandardCounter();
    }

    @Override
    public void newByte(int aByte) {
        this.counter.addToCount(1L);
    }

    @Override
    public void newBytes(byte[] bytes, int offset, int length) {
        this.counter.addToCount(length);
    }

    public void resetCount() {
        this.counter.resetCount();
    }

    public long getCount() {
        return this.counter.getCount();
    }

    public double getKibiBytes() {
        return (double)this.counter.getCount() * 9.765625E-4;
    }

    public double getMebiBytes() {
        return (double)this.counter.getCount() * 9.5367431640625E-7;
    }

    public double getGibiBytes() {
        return (double)this.counter.getCount() * 9.313225746154785E-10;
    }

    public long getAndResetCount() {
        return this.counter.getAndResetCount();
    }
}

