/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.state.signed;

import com.swirlds.base.units.TimeUnit;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.metrics.RunningAverageMetric;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;
import org.hiero.consensus.state.signed.StateGarbageCollector;

public class DefaultStateGarbageCollector
implements StateGarbageCollector {
    private static final Logger logger = LogManager.getLogger(DefaultStateGarbageCollector.class);
    private final List<SignedState> states = new LinkedList<SignedState>();
    private static final RunningAverageMetric.Config STATES_INELIGIBLE_FOR_DELETION = new RunningAverageMetric.Config("platform", "statesIneligibleForDeletion").withDescription("Average number of states in the state garbage collector that are not yet eligible for deletion").withUnit("count");
    private final RunningAverageMetric undeletableStates;
    private static final RunningAverageMetric.Config TIME_TO_DELETE_STATE_CONFIG = new RunningAverageMetric.Config("platform", "timeToDeleteState").withDescription("Average time to delete a state in the state garbage collector").withUnit("microseconds");
    private final RunningAverageMetric timeToDeleteState;

    public DefaultStateGarbageCollector(@NonNull Metrics metrics) {
        this.undeletableStates = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)STATES_INELIGIBLE_FOR_DELETION);
        this.timeToDeleteState = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)TIME_TO_DELETE_STATE_CONFIG);
    }

    @Override
    public void registerState(@NonNull ReservedSignedState reservedState) {
        try (ReservedSignedState reservedSignedState = reservedState;){
            SignedState state = reservedState.get();
            if (state.shouldDeleteOnBackgroundThread()) {
                this.states.add(state);
            } else {
                logger.error(LogMarker.EXCEPTION.getMarker(), "State for round {} is not configured to be deleted on background thread", (Object)state.getRound());
            }
        }
    }

    @Override
    public void heartbeat() {
        Iterator<SignedState> iterator = this.states.iterator();
        while (iterator.hasNext()) {
            SignedState signedState = iterator.next();
            if (!signedState.isEligibleForDeletion()) continue;
            Instant start = Instant.now();
            signedState.delete();
            Instant end = Instant.now();
            Duration duration = Duration.between(start, end);
            this.timeToDeleteState.update(TimeUnit.UNIT_NANOSECONDS.convertTo(duration.toNanos(), TimeUnit.UNIT_MICROSECONDS));
            iterator.remove();
        }
        this.undeletableStates.update((double)this.states.size());
    }
}

