/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import java.util.List;

public enum ResponseType implements EnumWithProtoMetadata
{
    ANSWER_ONLY(0, "ANSWER_ONLY"),
    ANSWER_STATE_PROOF(1, "ANSWER_STATE_PROOF"),
    COST_ANSWER(2, "COST_ANSWER"),
    COST_ANSWER_STATE_PROOF(3, "COST_ANSWER_STATE_PROOF"),
    UNRECOGNIZED(-1, "UNRECOGNIZED");

    private final int protoOrdinal;
    private final String protoName;

    private ResponseType(int protoOrdinal, String protoName) {
        this.protoOrdinal = protoOrdinal;
        this.protoName = protoName;
    }

    public int protoOrdinal() {
        return this.protoOrdinal;
    }

    public String protoName() {
        return this.protoName;
    }

    public static ResponseType fromProtobufOrdinal(int ordinal) {
        return switch (ordinal) {
            case 0 -> ANSWER_ONLY;
            case 1 -> ANSWER_STATE_PROOF;
            case 2 -> COST_ANSWER;
            case 3 -> COST_ANSWER_STATE_PROOF;
            default -> UNRECOGNIZED;
        };
    }

    public static ResponseType fromString(String name) {
        return switch (name) {
            case "ANSWER_ONLY" -> ANSWER_ONLY;
            case "ANSWER_STATE_PROOF" -> ANSWER_STATE_PROOF;
            case "COST_ANSWER" -> COST_ANSWER;
            case "COST_ANSWER_STATE_PROOF" -> COST_ANSWER_STATE_PROOF;
            default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
        };
    }

    public static ResponseType fromObject(Object obj) {
        if (obj == null) {
            return ResponseType.fromProtobufOrdinal(0);
        }
        if (obj instanceof ResponseType) {
            ResponseType pbjEnum = (ResponseType)((Object)obj);
            return pbjEnum;
        }
        return UNRECOGNIZED;
    }

    public static List<ResponseType> fromObjects(List<?> list) {
        return list.stream().map(ResponseType::fromObject).toList();
    }

    public static int toProtoOrdinal(Object obj) {
        if (obj instanceof ResponseType) {
            ResponseType pbjEnum = (ResponseType)((Object)obj);
            return pbjEnum.protoOrdinal();
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return i;
        }
        throw new IllegalArgumentException("Neither ResponseType, nor Integer, but: " + obj.getClass().getName());
    }

    public static List<Integer> toProtoOrdinals(List<?> list) {
        return list.stream().map(ResponseType::toProtoOrdinal).toList();
    }

    public static int compare(Object o1, Object o2) {
        int i2;
        int i1;
        if (o1 instanceof ResponseType) {
            ResponseType e1 = (ResponseType)((Object)o1);
            if (o2 instanceof ResponseType) {
                ResponseType e2 = (ResponseType)((Object)o2);
                return e1.compareTo(e2);
            }
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 instanceof ResponseType) {
            ResponseType e1 = (ResponseType)((Object)o1);
            i1 = e1.protoOrdinal();
        } else if (o1 instanceof Integer) {
            Integer ii1 = (Integer)o1;
            i1 = ii1;
        } else {
            throw new IllegalArgumentException("o1 is neither ResponseType, nor Integer. It's: " + o1.getClass().getName());
        }
        if (o2 instanceof ResponseType) {
            ResponseType e2 = (ResponseType)((Object)o2);
            i2 = e2.protoOrdinal();
        } else if (o2 instanceof Integer) {
            Integer ii2 = (Integer)o2;
            i2 = ii2;
        } else {
            throw new IllegalArgumentException("o2 is neither ResponseType, nor Integer. It's: " + o2.getClass().getName());
        }
        return Integer.compare(i1, i2);
    }
}

