/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.codec.SignaturePairJsonCodec;
import com.hedera.hapi.node.base.codec.SignaturePairProtoCodec;
import com.hedera.hapi.node.base.schema.SignaturePairSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class SignaturePair {
    public static final Codec<SignaturePair> PROTOBUF = new SignaturePairProtoCodec();
    public static final JsonCodec<SignaturePair> JSON = new SignaturePairJsonCodec();
    public static final SignaturePair DEFAULT = SignaturePair.newBuilder().build();
    @NonNull
    private final Bytes pubKeyPrefix;
    private final OneOf<SignatureOneOfType> signature;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public SignaturePair(Bytes pubKeyPrefix, OneOf<SignatureOneOfType> signature) {
        this.$unknownFields = null;
        Bytes bytes = this.pubKeyPrefix = pubKeyPrefix != null ? pubKeyPrefix : Bytes.EMPTY;
        if (signature == null) {
            throw new NullPointerException("Parameter 'signature' must be supplied and can not be null");
        }
        this.signature = signature;
    }

    public SignaturePair(Bytes pubKeyPrefix, OneOf<SignatureOneOfType> signature, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        Bytes bytes = this.pubKeyPrefix = pubKeyPrefix != null ? pubKeyPrefix : Bytes.EMPTY;
        if (signature == null) {
            throw new NullPointerException("Parameter 'signature' must be supplied and can not be null");
        }
        this.signature = signature;
    }

    public Bytes pubKeyPrefix() {
        return this.pubKeyPrefix;
    }

    public OneOf<SignatureOneOfType> signature() {
        return this.signature;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.PUB_KEY_PREFIX, (RandomAccessData)this.pubKeyPrefix, (boolean)true);
            if (this.signature.kind() == SignatureOneOfType.CONTRACT) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.CONTRACT, (RandomAccessData)((RandomAccessData)this.signature.as()), (boolean)true);
            }
            if (this.signature.kind() == SignatureOneOfType.ED25519) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.ED25519, (RandomAccessData)((RandomAccessData)this.signature.as()), (boolean)true);
            }
            if (this.signature.kind() == SignatureOneOfType.RSA_3072) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.RSA_3072, (RandomAccessData)((RandomAccessData)this.signature.as()), (boolean)true);
            }
            if (this.signature.kind() == SignatureOneOfType.ECDSA_384) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.ECDSA_384, (RandomAccessData)((RandomAccessData)this.signature.as()), (boolean)true);
            }
            if (this.signature.kind() == SignatureOneOfType.ECDSA_SECP256K1) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignaturePairSchema.ECDSA_SECP256K1, (RandomAccessData)((RandomAccessData)this.signature.as()), (boolean)true);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.pubKeyPrefix != null && !this.pubKeyPrefix.equals((Object)SignaturePair.DEFAULT.pubKeyPrefix)) {
                result = 31 * result + this.pubKeyPrefix.hashCode();
            }
            if (this.signature != null && !this.signature.equals(SignaturePair.DEFAULT.signature)) {
                result = 31 * result + this.signature.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SignaturePair thatObj = (SignaturePair)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.pubKeyPrefix == null && thatObj.pubKeyPrefix != null) {
            return false;
        }
        if (this.pubKeyPrefix != null && !this.pubKeyPrefix.equals((Object)thatObj.pubKeyPrefix)) {
            return false;
        }
        if (this.signature == null && thatObj.signature != null) {
            return false;
        }
        if (this.signature != null && !this.signature.equals(thatObj.signature)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "SignaturePair[pubKeyPrefix=" + String.valueOf(this.pubKeyPrefix) + ", signature=" + String.valueOf(this.signature) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public Bytes contract() {
        return this.signature.kind() == SignatureOneOfType.CONTRACT ? (Bytes)this.signature.value() : null;
    }

    public boolean hasContract() {
        return this.signature.kind() == SignatureOneOfType.CONTRACT;
    }

    public Bytes contractOrElse(@NonNull Bytes defaultValue) {
        return this.hasContract() ? this.contract() : defaultValue;
    }

    @NonNull
    public Bytes contractOrThrow() {
        return Objects.requireNonNull(this.contract(), "Field contract is null");
    }

    @Nullable
    public Bytes ed25519() {
        return this.signature.kind() == SignatureOneOfType.ED25519 ? (Bytes)this.signature.value() : null;
    }

    public boolean hasEd25519() {
        return this.signature.kind() == SignatureOneOfType.ED25519;
    }

    public Bytes ed25519OrElse(@NonNull Bytes defaultValue) {
        return this.hasEd25519() ? this.ed25519() : defaultValue;
    }

    @NonNull
    public Bytes ed25519OrThrow() {
        return Objects.requireNonNull(this.ed25519(), "Field ed25519 is null");
    }

    @Nullable
    public Bytes rsa3072() {
        return this.signature.kind() == SignatureOneOfType.RSA_3072 ? (Bytes)this.signature.value() : null;
    }

    public boolean hasRsa3072() {
        return this.signature.kind() == SignatureOneOfType.RSA_3072;
    }

    public Bytes rsa3072OrElse(@NonNull Bytes defaultValue) {
        return this.hasRsa3072() ? this.rsa3072() : defaultValue;
    }

    @NonNull
    public Bytes rsa3072OrThrow() {
        return Objects.requireNonNull(this.rsa3072(), "Field rsa3072 is null");
    }

    @Nullable
    public Bytes ecdsa384() {
        return this.signature.kind() == SignatureOneOfType.ECDSA_384 ? (Bytes)this.signature.value() : null;
    }

    public boolean hasEcdsa384() {
        return this.signature.kind() == SignatureOneOfType.ECDSA_384;
    }

    public Bytes ecdsa384OrElse(@NonNull Bytes defaultValue) {
        return this.hasEcdsa384() ? this.ecdsa384() : defaultValue;
    }

    @NonNull
    public Bytes ecdsa384OrThrow() {
        return Objects.requireNonNull(this.ecdsa384(), "Field ecdsa384 is null");
    }

    @Nullable
    public Bytes ecdsaSecp256k1() {
        return this.signature.kind() == SignatureOneOfType.ECDSA_SECP256K1 ? (Bytes)this.signature.value() : null;
    }

    public boolean hasEcdsaSecp256k1() {
        return this.signature.kind() == SignatureOneOfType.ECDSA_SECP256K1;
    }

    public Bytes ecdsaSecp256k1OrElse(@NonNull Bytes defaultValue) {
        return this.hasEcdsaSecp256k1() ? this.ecdsaSecp256k1() : defaultValue;
    }

    @NonNull
    public Bytes ecdsaSecp256k1OrThrow() {
        return Objects.requireNonNull(this.ecdsaSecp256k1(), "Field ecdsaSecp256k1 is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.pubKeyPrefix, this.signature, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum SignatureOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        CONTRACT(2, "contract"),
        ED25519(3, "ed25519"),
        RSA_3072(4, "RSA_3072"),
        ECDSA_384(5, "ECDSA_384"),
        ECDSA_SECP256K1(6, "ECDSA_secp256k1");

        private final int protoOrdinal;
        private final String protoName;

        private SignatureOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static SignatureOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 2 -> CONTRACT;
                case 3 -> ED25519;
                case 4 -> RSA_3072;
                case 5 -> ECDSA_384;
                case 6 -> ECDSA_SECP256K1;
                default -> UNSET;
            };
        }

        public static SignatureOneOfType fromString(String name) {
            return switch (name) {
                case "contract", "CONTRACT" -> CONTRACT;
                case "ed25519", "ED25519" -> ED25519;
                case "RSA_3072" -> RSA_3072;
                case "ECDSA_384" -> ECDSA_384;
                case "ECDSA_secp256k1", "ECDSA_SECP256K1" -> ECDSA_SECP256K1;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }

        public static SignatureOneOfType fromObject(Object obj) {
            if (obj == null) {
                return SignatureOneOfType.fromProtobufOrdinal(0);
            }
            if (obj instanceof SignatureOneOfType) {
                SignatureOneOfType pbjEnum = (SignatureOneOfType)((Object)obj);
                return pbjEnum;
            }
            return UNSET;
        }

        public static List<SignatureOneOfType> fromObjects(List<?> list) {
            return list.stream().map(SignatureOneOfType::fromObject).toList();
        }

        public static int toProtoOrdinal(Object obj) {
            if (obj instanceof SignatureOneOfType) {
                SignatureOneOfType pbjEnum = (SignatureOneOfType)((Object)obj);
                return pbjEnum.protoOrdinal();
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return i;
            }
            throw new IllegalArgumentException("Neither SignatureOneOfType, nor Integer, but: " + obj.getClass().getName());
        }

        public static List<Integer> toProtoOrdinals(List<?> list) {
            return list.stream().map(SignatureOneOfType::toProtoOrdinal).toList();
        }

        public static int compare(Object o1, Object o2) {
            int i2;
            int i1;
            if (o1 instanceof SignatureOneOfType) {
                SignatureOneOfType e1 = (SignatureOneOfType)((Object)o1);
                if (o2 instanceof SignatureOneOfType) {
                    SignatureOneOfType e2 = (SignatureOneOfType)((Object)o2);
                    return e1.compareTo(e2);
                }
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof SignatureOneOfType) {
                SignatureOneOfType e1 = (SignatureOneOfType)((Object)o1);
                i1 = e1.protoOrdinal();
            } else if (o1 instanceof Integer) {
                Integer ii1 = (Integer)o1;
                i1 = ii1;
            } else {
                throw new IllegalArgumentException("o1 is neither SignatureOneOfType, nor Integer. It's: " + o1.getClass().getName());
            }
            if (o2 instanceof SignatureOneOfType) {
                SignatureOneOfType e2 = (SignatureOneOfType)((Object)o2);
                i2 = e2.protoOrdinal();
            } else if (o2 instanceof Integer) {
                Integer ii2 = (Integer)o2;
                i2 = ii2;
            } else {
                throw new IllegalArgumentException("o2 is neither SignatureOneOfType, nor Integer. It's: " + o2.getClass().getName());
            }
            return Integer.compare(i1, i2);
        }
    }

    public static final class Builder {
        @NonNull
        private Bytes pubKeyPrefix = Bytes.EMPTY;
        private OneOf<SignatureOneOfType> signature = SignaturePairProtoCodec.SIGNATURE_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(Bytes pubKeyPrefix, OneOf<SignatureOneOfType> signature) {
            this.$unknownFields = null;
            this.pubKeyPrefix = pubKeyPrefix != null ? pubKeyPrefix : Bytes.EMPTY;
            this.signature = signature;
        }

        public Builder(Bytes pubKeyPrefix, OneOf<SignatureOneOfType> signature, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.pubKeyPrefix = pubKeyPrefix != null ? pubKeyPrefix : Bytes.EMPTY;
            this.signature = signature;
        }

        public SignaturePair build() {
            return new SignaturePair(this.pubKeyPrefix, this.signature);
        }

        public Builder pubKeyPrefix(@NonNull Bytes pubKeyPrefix) {
            this.pubKeyPrefix = pubKeyPrefix != null ? pubKeyPrefix : Bytes.EMPTY;
            return this;
        }

        public void clearSignature() {
            this.signature = SignaturePairProtoCodec.SIGNATURE_UNSET;
        }

        public Builder contract(@NonNull Bytes contract) {
            this.signature = new OneOf((Enum)SignatureOneOfType.CONTRACT, (Object)contract);
            return this;
        }

        public Builder ed25519(@NonNull Bytes ed25519) {
            this.signature = new OneOf((Enum)SignatureOneOfType.ED25519, (Object)ed25519);
            return this;
        }

        public Builder rsa3072(@NonNull Bytes rsa3072) {
            this.signature = new OneOf((Enum)SignatureOneOfType.RSA_3072, (Object)rsa3072);
            return this;
        }

        public Builder ecdsa384(@NonNull Bytes ecdsa384) {
            this.signature = new OneOf((Enum)SignatureOneOfType.ECDSA_384, (Object)ecdsa384);
            return this;
        }

        public Builder ecdsaSecp256k1(@NonNull Bytes ecdsaSecp256k1) {
            this.signature = new OneOf((Enum)SignatureOneOfType.ECDSA_SECP256K1, (Object)ecdsaSecp256k1);
            return this;
        }

        public Bytes pubKeyPrefix() {
            return this.pubKeyPrefix;
        }

        public OneOf<SignatureOneOfType> signature() {
            return this.signature;
        }
    }
}

