/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.scheduled;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.codec.ScheduleInfoJsonCodec;
import com.hedera.hapi.node.scheduled.codec.ScheduleInfoProtoCodec;
import com.hedera.hapi.node.scheduled.schema.ScheduleInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class ScheduleInfo {
    public static final Codec<ScheduleInfo> PROTOBUF = new ScheduleInfoProtoCodec();
    public static final JsonCodec<ScheduleInfo> JSON = new ScheduleInfoJsonCodec();
    public static final ScheduleInfo DEFAULT = ScheduleInfo.newBuilder().build();
    @Nullable
    private final ScheduleID scheduleID;
    private final OneOf<DataOneOfType> data;
    @Nullable
    private final Timestamp expirationTime;
    @Nullable
    private final SchedulableTransactionBody scheduledTransactionBody;
    @NonNull
    private final String memo;
    @Nullable
    private final Key adminKey;
    @Nullable
    private final KeyList signers;
    @Nullable
    private final AccountID creatorAccountID;
    @Nullable
    private final AccountID payerAccountID;
    @Nullable
    private final TransactionID scheduledTransactionID;
    @NonNull
    private final Bytes ledgerId;
    private final boolean waitForExpiry;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public ScheduleInfo(ScheduleID scheduleID, OneOf<DataOneOfType> data, Timestamp expirationTime, SchedulableTransactionBody scheduledTransactionBody, String memo, Key adminKey, KeyList signers, AccountID creatorAccountID, AccountID payerAccountID, TransactionID scheduledTransactionID, Bytes ledgerId, boolean waitForExpiry) {
        this.$unknownFields = null;
        this.scheduleID = scheduleID;
        if (data == null) {
            throw new NullPointerException("Parameter 'data' must be supplied and can not be null");
        }
        this.data = data;
        this.expirationTime = expirationTime;
        this.scheduledTransactionBody = scheduledTransactionBody;
        this.memo = memo != null ? memo : "";
        this.adminKey = adminKey;
        this.signers = signers;
        this.creatorAccountID = creatorAccountID;
        this.payerAccountID = payerAccountID;
        this.scheduledTransactionID = scheduledTransactionID;
        this.ledgerId = ledgerId != null ? ledgerId : Bytes.EMPTY;
        this.waitForExpiry = waitForExpiry;
    }

    public ScheduleInfo(ScheduleID scheduleID, OneOf<DataOneOfType> data, Timestamp expirationTime, SchedulableTransactionBody scheduledTransactionBody, String memo, Key adminKey, KeyList signers, AccountID creatorAccountID, AccountID payerAccountID, TransactionID scheduledTransactionID, Bytes ledgerId, boolean waitForExpiry, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.scheduleID = scheduleID;
        if (data == null) {
            throw new NullPointerException("Parameter 'data' must be supplied and can not be null");
        }
        this.data = data;
        this.expirationTime = expirationTime;
        this.scheduledTransactionBody = scheduledTransactionBody;
        this.memo = memo != null ? memo : "";
        this.adminKey = adminKey;
        this.signers = signers;
        this.creatorAccountID = creatorAccountID;
        this.payerAccountID = payerAccountID;
        this.scheduledTransactionID = scheduledTransactionID;
        this.ledgerId = ledgerId != null ? ledgerId : Bytes.EMPTY;
        this.waitForExpiry = waitForExpiry;
    }

    public ScheduleID scheduleID() {
        return this.scheduleID;
    }

    public OneOf<DataOneOfType> data() {
        return this.data;
    }

    public Timestamp expirationTime() {
        return this.expirationTime;
    }

    public SchedulableTransactionBody scheduledTransactionBody() {
        return this.scheduledTransactionBody;
    }

    public String memo() {
        return this.memo;
    }

    public Key adminKey() {
        return this.adminKey;
    }

    public KeyList signers() {
        return this.signers;
    }

    public AccountID creatorAccountID() {
        return this.creatorAccountID;
    }

    public AccountID payerAccountID() {
        return this.payerAccountID;
    }

    public TransactionID scheduledTransactionID() {
        return this.scheduledTransactionID;
    }

    public Bytes ledgerId() {
        return this.ledgerId;
    }

    public boolean waitForExpiry() {
        return this.waitForExpiry;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleInfoSchema.SCHEDULE_ID, (Object)this.scheduleID, ScheduleID.PROTOBUF);
            if (this.data.kind() == DataOneOfType.DELETION_TIME) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleInfoSchema.DELETION_TIME, (Object)((Timestamp)this.data.as()), Timestamp.PROTOBUF);
            }
            if (this.data.kind() == DataOneOfType.EXECUTION_TIME) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleInfoSchema.EXECUTION_TIME, (Object)((Timestamp)this.data.as()), Timestamp.PROTOBUF);
            }
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleInfoSchema.EXPIRATION_TIME, (Object)this.expirationTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleInfoSchema.SCHEDULED_TRANSACTION_BODY, (Object)this.scheduledTransactionBody, SchedulableTransactionBody.PROTOBUF);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)ScheduleInfoSchema.MEMO, (String)this.memo, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleInfoSchema.ADMIN_KEY, (Object)this.adminKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleInfoSchema.SIGNERS, (Object)this.signers, KeyList.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleInfoSchema.CREATOR_ACCOUNT_ID, (Object)this.creatorAccountID, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleInfoSchema.PAYER_ACCOUNT_ID, (Object)this.payerAccountID, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleInfoSchema.SCHEDULED_TRANSACTION_ID, (Object)this.scheduledTransactionID, TransactionID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ScheduleInfoSchema.LEDGER_ID, (RandomAccessData)this.ledgerId, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)ScheduleInfoSchema.WAIT_FOR_EXPIRY, (boolean)this.waitForExpiry, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.scheduleID != null && !this.scheduleID.equals(ScheduleInfo.DEFAULT.scheduleID)) {
                result = 31 * result + this.scheduleID.hashCode();
            }
            if (this.data != null && !this.data.equals(ScheduleInfo.DEFAULT.data)) {
                result = 31 * result + this.data.hashCode();
            }
            if (this.expirationTime != null && !this.expirationTime.equals(ScheduleInfo.DEFAULT.expirationTime)) {
                result = 31 * result + this.expirationTime.hashCode();
            }
            if (this.scheduledTransactionBody != null && !this.scheduledTransactionBody.equals(ScheduleInfo.DEFAULT.scheduledTransactionBody)) {
                result = 31 * result + this.scheduledTransactionBody.hashCode();
            }
            if (this.memo != null && !this.memo.equals(ScheduleInfo.DEFAULT.memo)) {
                result = 31 * result + this.memo.hashCode();
            }
            if (this.adminKey != null && !this.adminKey.equals(ScheduleInfo.DEFAULT.adminKey)) {
                result = 31 * result + this.adminKey.hashCode();
            }
            if (this.signers != null && !this.signers.equals(ScheduleInfo.DEFAULT.signers)) {
                result = 31 * result + this.signers.hashCode();
            }
            if (this.creatorAccountID != null && !this.creatorAccountID.equals(ScheduleInfo.DEFAULT.creatorAccountID)) {
                result = 31 * result + this.creatorAccountID.hashCode();
            }
            if (this.payerAccountID != null && !this.payerAccountID.equals(ScheduleInfo.DEFAULT.payerAccountID)) {
                result = 31 * result + this.payerAccountID.hashCode();
            }
            if (this.scheduledTransactionID != null && !this.scheduledTransactionID.equals(ScheduleInfo.DEFAULT.scheduledTransactionID)) {
                result = 31 * result + this.scheduledTransactionID.hashCode();
            }
            if (this.ledgerId != null && !this.ledgerId.equals((Object)ScheduleInfo.DEFAULT.ledgerId)) {
                result = 31 * result + this.ledgerId.hashCode();
            }
            if (this.waitForExpiry != ScheduleInfo.DEFAULT.waitForExpiry) {
                result = 31 * result + Boolean.hashCode(this.waitForExpiry);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ScheduleInfo thatObj = (ScheduleInfo)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.scheduleID == null && thatObj.scheduleID != null) {
            return false;
        }
        if (this.scheduleID != null && !this.scheduleID.equals(thatObj.scheduleID)) {
            return false;
        }
        if (this.data == null && thatObj.data != null) {
            return false;
        }
        if (this.data != null && !this.data.equals(thatObj.data)) {
            return false;
        }
        if (this.expirationTime == null && thatObj.expirationTime != null) {
            return false;
        }
        if (this.expirationTime != null && !this.expirationTime.equals(thatObj.expirationTime)) {
            return false;
        }
        if (this.scheduledTransactionBody == null && thatObj.scheduledTransactionBody != null) {
            return false;
        }
        if (this.scheduledTransactionBody != null && !this.scheduledTransactionBody.equals(thatObj.scheduledTransactionBody)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.signers == null && thatObj.signers != null) {
            return false;
        }
        if (this.signers != null && !this.signers.equals(thatObj.signers)) {
            return false;
        }
        if (this.creatorAccountID == null && thatObj.creatorAccountID != null) {
            return false;
        }
        if (this.creatorAccountID != null && !this.creatorAccountID.equals(thatObj.creatorAccountID)) {
            return false;
        }
        if (this.payerAccountID == null && thatObj.payerAccountID != null) {
            return false;
        }
        if (this.payerAccountID != null && !this.payerAccountID.equals(thatObj.payerAccountID)) {
            return false;
        }
        if (this.scheduledTransactionID == null && thatObj.scheduledTransactionID != null) {
            return false;
        }
        if (this.scheduledTransactionID != null && !this.scheduledTransactionID.equals(thatObj.scheduledTransactionID)) {
            return false;
        }
        if (this.ledgerId == null && thatObj.ledgerId != null) {
            return false;
        }
        if (this.ledgerId != null && !this.ledgerId.equals((Object)thatObj.ledgerId)) {
            return false;
        }
        if (this.waitForExpiry != thatObj.waitForExpiry) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "ScheduleInfo[scheduleID=" + String.valueOf(this.scheduleID) + ", data=" + String.valueOf(this.data) + ", expirationTime=" + String.valueOf(this.expirationTime) + ", scheduledTransactionBody=" + String.valueOf(this.scheduledTransactionBody) + ", memo=" + this.memo + ", adminKey=" + String.valueOf(this.adminKey) + ", signers=" + String.valueOf(this.signers) + ", creatorAccountID=" + String.valueOf(this.creatorAccountID) + ", payerAccountID=" + String.valueOf(this.payerAccountID) + ", scheduledTransactionID=" + String.valueOf(this.scheduledTransactionID) + ", ledgerId=" + String.valueOf(this.ledgerId) + ", waitForExpiry=" + this.waitForExpiry + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasScheduleID() {
        return this.scheduleID != null;
    }

    public ScheduleID scheduleIDOrElse(@NonNull ScheduleID defaultValue) {
        return this.hasScheduleID() ? this.scheduleID : defaultValue;
    }

    @NonNull
    public ScheduleID scheduleIDOrThrow() {
        return Objects.requireNonNull(this.scheduleID, "Field scheduleID is null");
    }

    public void ifScheduleID(@NonNull Consumer<ScheduleID> ifPresent) {
        if (this.hasScheduleID()) {
            ifPresent.accept(this.scheduleID);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasScheduledTransactionBody() {
        return this.scheduledTransactionBody != null;
    }

    public SchedulableTransactionBody scheduledTransactionBodyOrElse(@NonNull SchedulableTransactionBody defaultValue) {
        return this.hasScheduledTransactionBody() ? this.scheduledTransactionBody : defaultValue;
    }

    @NonNull
    public SchedulableTransactionBody scheduledTransactionBodyOrThrow() {
        return Objects.requireNonNull(this.scheduledTransactionBody, "Field scheduledTransactionBody is null");
    }

    public void ifScheduledTransactionBody(@NonNull Consumer<SchedulableTransactionBody> ifPresent) {
        if (this.hasScheduledTransactionBody()) {
            ifPresent.accept(this.scheduledTransactionBody);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasSigners() {
        return this.signers != null;
    }

    public KeyList signersOrElse(@NonNull KeyList defaultValue) {
        return this.hasSigners() ? this.signers : defaultValue;
    }

    @NonNull
    public KeyList signersOrThrow() {
        return Objects.requireNonNull(this.signers, "Field signers is null");
    }

    public void ifSigners(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasSigners()) {
            ifPresent.accept(this.signers);
        }
    }

    public boolean hasCreatorAccountID() {
        return this.creatorAccountID != null;
    }

    public AccountID creatorAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasCreatorAccountID() ? this.creatorAccountID : defaultValue;
    }

    @NonNull
    public AccountID creatorAccountIDOrThrow() {
        return Objects.requireNonNull(this.creatorAccountID, "Field creatorAccountID is null");
    }

    public void ifCreatorAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasCreatorAccountID()) {
            ifPresent.accept(this.creatorAccountID);
        }
    }

    public boolean hasPayerAccountID() {
        return this.payerAccountID != null;
    }

    public AccountID payerAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasPayerAccountID() ? this.payerAccountID : defaultValue;
    }

    @NonNull
    public AccountID payerAccountIDOrThrow() {
        return Objects.requireNonNull(this.payerAccountID, "Field payerAccountID is null");
    }

    public void ifPayerAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasPayerAccountID()) {
            ifPresent.accept(this.payerAccountID);
        }
    }

    public boolean hasScheduledTransactionID() {
        return this.scheduledTransactionID != null;
    }

    public TransactionID scheduledTransactionIDOrElse(@NonNull TransactionID defaultValue) {
        return this.hasScheduledTransactionID() ? this.scheduledTransactionID : defaultValue;
    }

    @NonNull
    public TransactionID scheduledTransactionIDOrThrow() {
        return Objects.requireNonNull(this.scheduledTransactionID, "Field scheduledTransactionID is null");
    }

    public void ifScheduledTransactionID(@NonNull Consumer<TransactionID> ifPresent) {
        if (this.hasScheduledTransactionID()) {
            ifPresent.accept(this.scheduledTransactionID);
        }
    }

    @Nullable
    public Timestamp deletionTime() {
        return this.data.kind() == DataOneOfType.DELETION_TIME ? (Timestamp)this.data.value() : null;
    }

    public boolean hasDeletionTime() {
        return this.data.kind() == DataOneOfType.DELETION_TIME;
    }

    public Timestamp deletionTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasDeletionTime() ? this.deletionTime() : defaultValue;
    }

    @NonNull
    public Timestamp deletionTimeOrThrow() {
        return Objects.requireNonNull(this.deletionTime(), "Field deletionTime is null");
    }

    @Nullable
    public Timestamp executionTime() {
        return this.data.kind() == DataOneOfType.EXECUTION_TIME ? (Timestamp)this.data.value() : null;
    }

    public boolean hasExecutionTime() {
        return this.data.kind() == DataOneOfType.EXECUTION_TIME;
    }

    public Timestamp executionTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExecutionTime() ? this.executionTime() : defaultValue;
    }

    @NonNull
    public Timestamp executionTimeOrThrow() {
        return Objects.requireNonNull(this.executionTime(), "Field executionTime is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.scheduleID, this.data, this.expirationTime, this.scheduledTransactionBody, this.memo, this.adminKey, this.signers, this.creatorAccountID, this.payerAccountID, this.scheduledTransactionID, this.ledgerId, this.waitForExpiry, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum DataOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        DELETION_TIME(2, "deletion_time"),
        EXECUTION_TIME(3, "execution_time");

        private final int protoOrdinal;
        private final String protoName;

        private DataOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static DataOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 2 -> DELETION_TIME;
                case 3 -> EXECUTION_TIME;
                default -> UNSET;
            };
        }

        public static DataOneOfType fromString(String name) {
            return switch (name) {
                case "deletion_time", "DELETION_TIME" -> DELETION_TIME;
                case "execution_time", "EXECUTION_TIME" -> EXECUTION_TIME;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }

        public static DataOneOfType fromObject(Object obj) {
            if (obj == null) {
                return DataOneOfType.fromProtobufOrdinal(0);
            }
            if (obj instanceof DataOneOfType) {
                DataOneOfType pbjEnum = (DataOneOfType)((Object)obj);
                return pbjEnum;
            }
            return UNSET;
        }

        public static List<DataOneOfType> fromObjects(List<?> list) {
            return list.stream().map(DataOneOfType::fromObject).toList();
        }

        public static int toProtoOrdinal(Object obj) {
            if (obj instanceof DataOneOfType) {
                DataOneOfType pbjEnum = (DataOneOfType)((Object)obj);
                return pbjEnum.protoOrdinal();
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return i;
            }
            throw new IllegalArgumentException("Neither DataOneOfType, nor Integer, but: " + obj.getClass().getName());
        }

        public static List<Integer> toProtoOrdinals(List<?> list) {
            return list.stream().map(DataOneOfType::toProtoOrdinal).toList();
        }

        public static int compare(Object o1, Object o2) {
            int i2;
            int i1;
            if (o1 instanceof DataOneOfType) {
                DataOneOfType e1 = (DataOneOfType)((Object)o1);
                if (o2 instanceof DataOneOfType) {
                    DataOneOfType e2 = (DataOneOfType)((Object)o2);
                    return e1.compareTo(e2);
                }
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof DataOneOfType) {
                DataOneOfType e1 = (DataOneOfType)((Object)o1);
                i1 = e1.protoOrdinal();
            } else if (o1 instanceof Integer) {
                Integer ii1 = (Integer)o1;
                i1 = ii1;
            } else {
                throw new IllegalArgumentException("o1 is neither DataOneOfType, nor Integer. It's: " + o1.getClass().getName());
            }
            if (o2 instanceof DataOneOfType) {
                DataOneOfType e2 = (DataOneOfType)((Object)o2);
                i2 = e2.protoOrdinal();
            } else if (o2 instanceof Integer) {
                Integer ii2 = (Integer)o2;
                i2 = ii2;
            } else {
                throw new IllegalArgumentException("o2 is neither DataOneOfType, nor Integer. It's: " + o2.getClass().getName());
            }
            return Integer.compare(i1, i2);
        }
    }

    public static final class Builder {
        @Nullable
        private ScheduleID scheduleID = null;
        private OneOf<DataOneOfType> data = ScheduleInfoProtoCodec.DATA_UNSET;
        @Nullable
        private Timestamp expirationTime = null;
        @Nullable
        private SchedulableTransactionBody scheduledTransactionBody = null;
        @NonNull
        private String memo = "";
        @Nullable
        private Key adminKey = null;
        @Nullable
        private KeyList signers = null;
        @Nullable
        private AccountID creatorAccountID = null;
        @Nullable
        private AccountID payerAccountID = null;
        @Nullable
        private TransactionID scheduledTransactionID = null;
        @NonNull
        private Bytes ledgerId = Bytes.EMPTY;
        private boolean waitForExpiry = false;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(ScheduleID scheduleID, OneOf<DataOneOfType> data, Timestamp expirationTime, SchedulableTransactionBody scheduledTransactionBody, String memo, Key adminKey, KeyList signers, AccountID creatorAccountID, AccountID payerAccountID, TransactionID scheduledTransactionID, Bytes ledgerId, boolean waitForExpiry) {
            this.$unknownFields = null;
            this.scheduleID = scheduleID;
            this.data = data;
            this.expirationTime = expirationTime;
            this.scheduledTransactionBody = scheduledTransactionBody;
            this.memo = memo != null ? memo : "";
            this.adminKey = adminKey;
            this.signers = signers;
            this.creatorAccountID = creatorAccountID;
            this.payerAccountID = payerAccountID;
            this.scheduledTransactionID = scheduledTransactionID;
            this.ledgerId = ledgerId != null ? ledgerId : Bytes.EMPTY;
            this.waitForExpiry = waitForExpiry;
        }

        public Builder(ScheduleID scheduleID, OneOf<DataOneOfType> data, Timestamp expirationTime, SchedulableTransactionBody scheduledTransactionBody, String memo, Key adminKey, KeyList signers, AccountID creatorAccountID, AccountID payerAccountID, TransactionID scheduledTransactionID, Bytes ledgerId, boolean waitForExpiry, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.scheduleID = scheduleID;
            this.data = data;
            this.expirationTime = expirationTime;
            this.scheduledTransactionBody = scheduledTransactionBody;
            this.memo = memo != null ? memo : "";
            this.adminKey = adminKey;
            this.signers = signers;
            this.creatorAccountID = creatorAccountID;
            this.payerAccountID = payerAccountID;
            this.scheduledTransactionID = scheduledTransactionID;
            this.ledgerId = ledgerId != null ? ledgerId : Bytes.EMPTY;
            this.waitForExpiry = waitForExpiry;
        }

        public ScheduleInfo build() {
            return new ScheduleInfo(this.scheduleID, this.data, this.expirationTime, this.scheduledTransactionBody, this.memo, this.adminKey, this.signers, this.creatorAccountID, this.payerAccountID, this.scheduledTransactionID, this.ledgerId, this.waitForExpiry);
        }

        public Builder scheduleID(@Nullable ScheduleID scheduleID) {
            this.scheduleID = scheduleID;
            return this;
        }

        public Builder scheduleID(ScheduleID.Builder builder) {
            this.scheduleID = builder.build();
            return this;
        }

        public void clearData() {
            this.data = ScheduleInfoProtoCodec.DATA_UNSET;
        }

        public Builder deletionTime(@Nullable Timestamp deletionTime) {
            this.data = new OneOf((Enum)DataOneOfType.DELETION_TIME, (Object)deletionTime);
            return this;
        }

        public Builder deletionTime(Timestamp.Builder builder) {
            this.data = new OneOf((Enum)DataOneOfType.DELETION_TIME, (Object)builder.build());
            return this;
        }

        public Builder executionTime(@Nullable Timestamp executionTime) {
            this.data = new OneOf((Enum)DataOneOfType.EXECUTION_TIME, (Object)executionTime);
            return this;
        }

        public Builder executionTime(Timestamp.Builder builder) {
            this.data = new OneOf((Enum)DataOneOfType.EXECUTION_TIME, (Object)builder.build());
            return this;
        }

        public Builder expirationTime(@Nullable Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder scheduledTransactionBody(@Nullable SchedulableTransactionBody scheduledTransactionBody) {
            this.scheduledTransactionBody = scheduledTransactionBody;
            return this;
        }

        public Builder scheduledTransactionBody(SchedulableTransactionBody.Builder builder) {
            this.scheduledTransactionBody = builder.build();
            return this;
        }

        public Builder memo(@NonNull String memo) {
            this.memo = memo != null ? memo : "";
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder signers(@Nullable KeyList signers) {
            this.signers = signers;
            return this;
        }

        public Builder signers(KeyList.Builder builder) {
            this.signers = builder.build();
            return this;
        }

        public Builder creatorAccountID(@Nullable AccountID creatorAccountID) {
            this.creatorAccountID = creatorAccountID;
            return this;
        }

        public Builder creatorAccountID(AccountID.Builder builder) {
            this.creatorAccountID = builder.build();
            return this;
        }

        public Builder payerAccountID(@Nullable AccountID payerAccountID) {
            this.payerAccountID = payerAccountID;
            return this;
        }

        public Builder payerAccountID(AccountID.Builder builder) {
            this.payerAccountID = builder.build();
            return this;
        }

        public Builder scheduledTransactionID(@Nullable TransactionID scheduledTransactionID) {
            this.scheduledTransactionID = scheduledTransactionID;
            return this;
        }

        public Builder scheduledTransactionID(TransactionID.Builder builder) {
            this.scheduledTransactionID = builder.build();
            return this;
        }

        public Builder ledgerId(@NonNull Bytes ledgerId) {
            this.ledgerId = ledgerId != null ? ledgerId : Bytes.EMPTY;
            return this;
        }

        public Builder waitForExpiry(boolean waitForExpiry) {
            this.waitForExpiry = waitForExpiry;
            return this;
        }

        public ScheduleID scheduleID() {
            return this.scheduleID;
        }

        public OneOf<DataOneOfType> data() {
            return this.data;
        }

        public Timestamp expirationTime() {
            return this.expirationTime;
        }

        public SchedulableTransactionBody scheduledTransactionBody() {
            return this.scheduledTransactionBody;
        }

        public String memo() {
            return this.memo;
        }

        public Key adminKey() {
            return this.adminKey;
        }

        public KeyList signers() {
            return this.signers;
        }

        public AccountID creatorAccountID() {
            return this.creatorAccountID;
        }

        public AccountID payerAccountID() {
            return this.payerAccountID;
        }

        public TransactionID scheduledTransactionID() {
            return this.scheduledTransactionID;
        }

        public Bytes ledgerId() {
            return this.ledgerId;
        }

        public boolean waitForExpiry() {
            return this.waitForExpiry;
        }
    }
}

