/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.gossip.sync;

import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.consensus.gossip.config.SocketConfig;
import org.hiero.consensus.io.extendable.ExtendableInputStream;
import org.hiero.consensus.io.extendable.InputStreamExtension;
import org.hiero.consensus.io.extendable.extensions.CountingStreamExtension;

public class SyncInputStream
extends SerializableDataInputStream {
    private final CountingStreamExtension syncByteCounter;

    private SyncInputStream(@NonNull InputStream in, @NonNull CountingStreamExtension syncByteCounter) {
        super(in);
        this.syncByteCounter = syncByteCounter;
    }

    public static SyncInputStream createSyncInputStream(@NonNull Configuration configuration, @NonNull InputStream in, int bufferSize) {
        CountingStreamExtension syncCounter = new CountingStreamExtension();
        boolean compress = ((SocketConfig)configuration.getConfigData(SocketConfig.class)).gzipCompression();
        InputStream meteredStream = ExtendableInputStream.extendInputStream((InputStream)in, (InputStreamExtension[])new InputStreamExtension[]{syncCounter});
        FilterInputStream wrappedStream = compress ? new InflaterInputStream(meteredStream, new Inflater(true), bufferSize) : new BufferedInputStream(meteredStream, bufferSize);
        return new SyncInputStream(wrappedStream, syncCounter);
    }

    public CountingStreamExtension getSyncByteCounter() {
        return this.syncByteCounter;
    }
}

