/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.vm;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.StateValue;
import com.swirlds.state.spi.WritableKVStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public final class VirtualMapWritableKVState<K, V>
extends WritableKVStateBase<K, V> {
    @NonNull
    private final VirtualMap virtualMap;
    @NonNull
    private final Codec<K> keyCodec;
    @NonNull
    private final Codec<StateValue<V>> stateValueCodec;

    public VirtualMapWritableKVState(int stateId, @NonNull String label, @NonNull Codec<K> keyCodec, @NonNull Codec<V> valueCodec, @NonNull VirtualMap virtualMap) {
        super(stateId, Objects.requireNonNull(label));
        this.keyCodec = Objects.requireNonNull(keyCodec);
        this.stateValueCodec = new StateValue.StateValueCodec<V>(stateId, Objects.requireNonNull(valueCodec));
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    protected V readFromDataSource(@NonNull K key) {
        Bytes stateKey = StateUtils.getStateKeyForKv(this.stateId, key, this.keyCodec);
        StateValue stateValue = (StateValue)this.virtualMap.get(stateKey, this.stateValueCodec);
        return stateValue != null ? (V)stateValue.value() : null;
    }

    protected void putIntoDataSource(@NonNull K key, @NonNull V value) {
        assert (this.keyCodec.toBytes(key) != null);
        Bytes keyBytes = StateUtils.getStateKeyForKv(this.stateId, key, this.keyCodec);
        StateValue<V> stateValue = StateUtils.getStateValueForKv(this.stateId, value);
        this.virtualMap.put(keyBytes, stateValue, this.stateValueCodec);
    }

    protected void removeFromDataSource(@NonNull K key) {
        Bytes stateKey = StateUtils.getStateKeyForKv(this.stateId, key, this.keyCodec);
        StateValue stateValue = (StateValue)this.virtualMap.remove(stateKey, this.stateValueCodec);
        Object removedValue = stateValue != null ? stateValue.value() : null;
    }

    public long sizeOfDataSource() {
        return this.virtualMap.size();
    }
}

