/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.reconnect.impl;

import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ReconnectFinishPayload;
import com.swirlds.logging.legacy.payload.ReconnectStartPayload;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.concurrent.BlockingResourceProvider;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.concurrent.utility.throttle.RateLimitedLogger;
import org.hiero.consensus.exceptions.ThrowableUtilities;
import org.hiero.consensus.gossip.ReservedSignedStateResult;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.gossip.impl.network.NetworkProtocolException;
import org.hiero.consensus.gossip.impl.network.protocol.PeerProtocol;
import org.hiero.consensus.metrics.extensions.CountPerSecond;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.monitoring.FallenBehindMonitor;
import org.hiero.consensus.platformstate.PlatformStateUtils;
import org.hiero.consensus.reconnect.config.ReconnectConfig;
import org.hiero.consensus.reconnect.impl.ReconnectStateLearner;
import org.hiero.consensus.reconnect.impl.ReconnectStateTeacher;
import org.hiero.consensus.reconnect.impl.ReconnectStateTeacherThrottle;
import org.hiero.consensus.state.config.StateConfig;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;

public class ReconnectStatePeerProtocol
implements PeerProtocol {
    private static final Logger logger = LogManager.getLogger(ReconnectStatePeerProtocol.class);
    private final NodeId peerId;
    private final ReconnectStateTeacherThrottle teacherThrottle;
    private final java.util.function.Supplier<ReservedSignedState> lastCompleteSignedState;
    private final Duration reconnectSocketTimeout;
    private final ReconnectMetrics reconnectMetrics;
    private final CountPerSecond reconnectRejectionMetrics;
    private InitiatedBy initiatedBy = InitiatedBy.NO_ONE;
    private final ThreadManager threadManager;
    private final FallenBehindMonitor fallenBehindMonitor;
    private final java.util.function.Supplier<PlatformStatus> platformStatusSupplier;
    private ReservedSignedState teacherState;
    private final RateLimitedLogger stateNullLogger;
    private final RateLimitedLogger stateIncompleteLogger;
    private final RateLimitedLogger fallenBehindLogger;
    private final RateLimitedLogger notActiveLogger;
    private final Configuration configuration;
    private final Metrics metrics;
    private final Time time;
    private final BlockingResourceProvider<ReservedSignedStateResult> reservedSignedStateResultProvider;
    private final StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager;

    public ReconnectStatePeerProtocol(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull ThreadManager threadManager, @NonNull NodeId peerId, @NonNull ReconnectStateTeacherThrottle teacherThrottle, @NonNull java.util.function.Supplier<ReservedSignedState> lastCompleteSignedState, @NonNull Duration reconnectSocketTimeout, @NonNull ReconnectMetrics reconnectMetrics, @NonNull FallenBehindMonitor fallenBehindMonitor, @NonNull java.util.function.Supplier<PlatformStatus> platformStatusSupplier, @NonNull BlockingResourceProvider<ReservedSignedStateResult> reservedSignedStateResultProvider, @NonNull StateLifecycleManager stateLifecycleManager) {
        this.configuration = Objects.requireNonNull(configuration);
        this.metrics = Objects.requireNonNull(metrics);
        this.time = Objects.requireNonNull(time);
        this.threadManager = Objects.requireNonNull(threadManager);
        this.peerId = Objects.requireNonNull(peerId);
        this.teacherThrottle = Objects.requireNonNull(teacherThrottle);
        this.lastCompleteSignedState = Objects.requireNonNull(lastCompleteSignedState);
        this.reconnectSocketTimeout = Objects.requireNonNull(reconnectSocketTimeout);
        this.reconnectMetrics = Objects.requireNonNull(reconnectMetrics);
        this.fallenBehindMonitor = Objects.requireNonNull(fallenBehindMonitor);
        this.platformStatusSupplier = Objects.requireNonNull(platformStatusSupplier);
        this.reservedSignedStateResultProvider = Objects.requireNonNull(reservedSignedStateResultProvider);
        this.stateLifecycleManager = Objects.requireNonNull(stateLifecycleManager);
        Duration minimumTimeBetweenReconnects = ((ReconnectConfig)configuration.getConfigData(ReconnectConfig.class)).minimumTimeBetweenReconnects();
        this.stateNullLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.stateIncompleteLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.fallenBehindLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.notActiveLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.reconnectRejectionMetrics = new CountPerSecond(reconnectMetrics.getMetrics(), new CountPerSecond.Config("platform", String.format("reconnectRejections_per_sec_%02d", peerId.id())).withDescription(String.format("number of reconnections rejected per second from node %02d", peerId.id())).withUnit("rejectionsPerSec").withFormat("%,10.0f"));
    }

    public boolean shouldInitiate() {
        if (!this.fallenBehindMonitor.hasFallenBehind()) {
            return false;
        }
        if (!this.fallenBehindMonitor.isBehindPeer(this.peerId)) {
            return false;
        }
        boolean acquiredPermit = this.reservedSignedStateResultProvider.acquireProvidePermit();
        if (acquiredPermit) {
            this.initiatedBy = InitiatedBy.SELF;
        }
        return acquiredPermit;
    }

    public void initiateFailed() {
        this.reservedSignedStateResultProvider.releaseProvidePermit();
        this.initiatedBy = InitiatedBy.NO_ONE;
    }

    public boolean shouldAccept() {
        if (this.fallenBehindMonitor.hasFallenBehind()) {
            this.fallenBehindLogger.info(LogMarker.RECONNECT.getMarker(), "Rejecting reconnect request from node {} because this node has fallen behind", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        if (this.platformStatusSupplier.get() != PlatformStatus.ACTIVE) {
            this.notActiveLogger.info(LogMarker.RECONNECT.getMarker(), "Rejecting reconnect request from node {} because this node isn't ACTIVE", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        this.teacherState = this.lastCompleteSignedState.get();
        if (this.teacherState == null || this.teacherState.isNull()) {
            this.stateNullLogger.info(LogMarker.RECONNECT.getMarker(), "Rejecting reconnect request from node {} due to lack of a fully signed state", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        if (!this.teacherState.get().isComplete()) {
            this.stateIncompleteLogger.error(LogMarker.EXCEPTION.getMarker(), "Rejecting reconnect request from node {} due to lack of a fully signed state. The signed state manager attempted to provide a state that was not fully signed, which should not be possible.", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        if (!this.reservedSignedStateResultProvider.tryBlockProvidePermit()) {
            this.reconnectRejected();
            return false;
        }
        boolean reconnectPermittedByThrottle = this.teacherThrottle.initiateReconnect(this.peerId);
        if (!reconnectPermittedByThrottle) {
            this.reconnectRejected();
            this.reservedSignedStateResultProvider.releaseProvidePermit();
            return false;
        }
        this.initiatedBy = InitiatedBy.PEER;
        return true;
    }

    private void reconnectRejected() {
        if (this.teacherState != null) {
            this.teacherState.close();
            this.teacherState = null;
        }
        this.reconnectRejectionMetrics.count();
    }

    public void acceptFailed() {
        this.teacherState.close();
        this.teacherState = null;
        this.teacherThrottle.reconnectAttemptFinished();
        this.reservedSignedStateResultProvider.releaseProvidePermit();
    }

    public boolean acceptOnSimultaneousInitiate() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runProtocol(Connection connection) throws NetworkProtocolException, IOException, InterruptedException {
        try {
            switch (this.initiatedBy.ordinal()) {
                case 2: {
                    this.teacher(connection);
                    return;
                }
                case 1: {
                    this.learner(connection);
                    return;
                }
                default: {
                    throw new NetworkProtocolException("runProtocol() called but it is unclear who the teacher and who the learner is");
                }
            }
        }
        finally {
            this.initiatedBy = InitiatedBy.NO_ONE;
        }
    }

    private void learner(Connection connection) {
        try {
            VirtualMapState consensusState = (VirtualMapState)this.stateLifecycleManager.getMutableState();
            ReconnectStateLearner learner = new ReconnectStateLearner(this.configuration, this.metrics, this.threadManager, connection, consensusState, this.reconnectSocketTimeout, this.reconnectMetrics, this.stateLifecycleManager);
            logger.info(LogMarker.RECONNECT.getMarker(), () -> new ReconnectStartPayload("Starting reconnect in role of the receiver.", true, connection.getSelfId().id(), connection.getOtherId().id(), PlatformStateUtils.roundOf((State)consensusState)).toString());
            ReservedSignedState reservedSignedState = learner.execute();
            logger.info(LogMarker.RECONNECT.getMarker(), () -> new ReconnectFinishPayload("Finished reconnect in the role of the receiver.", true, connection.getSelfId().id(), connection.getOtherId().id(), reservedSignedState.get().getRound()).toString());
            int debugHashDepth = ((StateConfig)this.configuration.getConfigData(StateConfig.class)).debugHashDepth();
            logger.info(LogMarker.RECONNECT.getMarker(), "Information for state received during reconnect:\n{}", new Supplier[]{() -> PlatformStateUtils.getInfoString((State)reservedSignedState.get().getState())});
            this.reservedSignedStateResultProvider.provide((Object)new ReservedSignedStateResult(reservedSignedState, null));
        }
        catch (RuntimeException e) {
            if (!ThrowableUtilities.isOrCausedBySocketException((Throwable)e) && connection != null) {
                connection.disconnect();
            }
            try {
                this.reservedSignedStateResultProvider.provide((Object)new ReservedSignedStateResult(null, e));
            }
            catch (InterruptedException ie) {
                this.reservedSignedStateResultProvider.releaseProvidePermit();
            }
        }
        catch (InterruptedException e) {
            this.reservedSignedStateResultProvider.releaseProvidePermit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teacher(Connection connection) {
        try {
            ReconnectStateTeacher teacher;
            SignedState state = this.teacherState.get();
            try {
                teacher = new ReconnectStateTeacher(this.configuration, this.time, this.threadManager, connection, this.reconnectSocketTimeout, connection.getSelfId(), connection.getOtherId(), state.getRound(), state, this.reconnectMetrics);
            }
            finally {
                this.teacherState.close();
            }
            teacher.execute();
        }
        finally {
            this.teacherThrottle.reconnectAttemptFinished();
            this.teacherState = null;
            this.reservedSignedStateResultProvider.releaseProvidePermit();
        }
    }

    private static enum InitiatedBy {
        NO_ONE,
        SELF,
        PEER;

    }
}

