/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.hedera.hapi.block.stream.output.MapChangeKey;
import com.hedera.hapi.block.stream.output.MapChangeValue;
import com.hedera.hapi.block.stream.output.MapDeleteChange;
import com.hedera.hapi.block.stream.output.MapUpdateChange;
import com.hedera.hapi.block.stream.output.QueuePopChange;
import com.hedera.hapi.block.stream.output.QueuePushChange;
import com.hedera.hapi.block.stream.output.StateChange;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.addressbook.RegisteredNode;
import com.hedera.hapi.node.state.common.EntityIDPair;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.hapi.node.state.contract.Bytecode;
import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.state.hints.HintsKeySet;
import com.hedera.hapi.node.state.hints.HintsPartyId;
import com.hedera.hapi.node.state.hints.PreprocessingVote;
import com.hedera.hapi.node.state.hints.PreprocessingVoteId;
import com.hedera.hapi.node.state.history.ConstructionNodeId;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.ProofKeySet;
import com.hedera.hapi.node.state.history.RecordedHistorySignature;
import com.hedera.hapi.node.state.history.WrapsMessageHistory;
import com.hedera.hapi.node.state.hooks.EvmHookSlotKey;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.primitives.ProtoLong;
import com.hedera.hapi.node.state.primitives.ProtoString;
import com.hedera.hapi.node.state.recordcache.TransactionReceiptEntries;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.schedule.ScheduleList;
import com.hedera.hapi.node.state.schedule.ScheduledCounts;
import com.hedera.hapi.node.state.schedule.ScheduledOrder;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshots;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountPendingAirdrop;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.state.tss.TssEncryptionKeys;
import com.hedera.hapi.node.state.tss.TssMessageMapKey;
import com.hedera.hapi.node.state.tss.TssVoteMapKey;
import com.hedera.hapi.platform.state.NodeId;
import com.hedera.hapi.services.auxiliary.hints.CrsPublicationTransactionBody;
import com.hedera.hapi.services.auxiliary.tss.TssMessageTransactionBody;
import com.hedera.hapi.services.auxiliary.tss.TssVoteTransactionBody;
import com.hedera.pbj.runtime.OneOf;
import com.swirlds.state.StateChangeListener;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class ImmediateStateChangeListener
implements StateChangeListener {
    private static final Set<StateChangeListener.StateType> TARGET_DATA_TYPES = EnumSet.of(StateChangeListener.StateType.MAP, StateChangeListener.StateType.QUEUE);
    private final List<StateChange> kvStateChanges = new ArrayList<StateChange>();
    private final List<StateChange> queueStateChanges = new ArrayList<StateChange>();
    @Nullable
    private Predicate<Object> logicallyIdenticalMapping;

    public void resetKvStateChanges(@Nullable Predicate<Object> logicallyIdenticalMapping) {
        this.logicallyIdenticalMapping = logicallyIdenticalMapping;
        this.kvStateChanges.clear();
    }

    public void resetQueueStateChanges() {
        this.queueStateChanges.clear();
    }

    public void reset(@Nullable Predicate<Object> logicallyIdenticalMapping) {
        this.logicallyIdenticalMapping = logicallyIdenticalMapping;
        this.kvStateChanges.clear();
        this.queueStateChanges.clear();
    }

    public Set<StateChangeListener.StateType> stateTypes() {
        return TARGET_DATA_TYPES;
    }

    public <K, V> void mapUpdateChange(int stateId, @NonNull K key, @NonNull V value) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(value, "value must not be null");
        boolean identical = this.logicallyIdenticalMapping != null && this.logicallyIdenticalMapping.test(key);
        MapUpdateChange change = new MapUpdateChange(ImmediateStateChangeListener.mapChangeKeyFor(key), ImmediateStateChangeListener.mapChangeValueFor(value), identical);
        StateChange stateChange = StateChange.newBuilder().stateId(stateId).mapUpdate(change).build();
        this.kvStateChanges.add(stateChange);
    }

    public <K> void mapDeleteChange(int stateId, @NonNull K key) {
        Objects.requireNonNull(key, "key must not be null");
        MapDeleteChange change = MapDeleteChange.newBuilder().key(ImmediateStateChangeListener.mapChangeKeyFor(key)).build();
        this.kvStateChanges.add(StateChange.newBuilder().stateId(stateId).mapDelete(change).build());
    }

    public <V> void queuePushChange(int stateId, @NonNull V value) {
        Objects.requireNonNull(value);
        StateChange stateChange = StateChange.newBuilder().stateId(stateId).queuePush(new QueuePushChange(ImmediateStateChangeListener.queuePushChangeValueFor(value))).build();
        this.queueStateChanges.add(stateChange);
    }

    public void queuePopChange(int stateId) {
        StateChange stateChange = StateChange.newBuilder().stateId(stateId).queuePop(new QueuePopChange()).build();
        this.queueStateChanges.add(stateChange);
    }

    public List<StateChange> getKvStateChanges() {
        return this.kvStateChanges;
    }

    public List<StateChange> getQueueStateChanges() {
        return this.queueStateChanges;
    }

    public List<StateChange> getStateChanges() {
        LinkedList<StateChange> allStateChanges = new LinkedList<StateChange>();
        allStateChanges.addAll(this.kvStateChanges);
        allStateChanges.addAll(this.queueStateChanges);
        return allStateChanges;
    }

    private static <K> MapChangeKey mapChangeKeyFor(@NonNull K key) {
        K k = key;
        Objects.requireNonNull(k);
        K k2 = k;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AccountID.class, EntityIDPair.class, EntityNumber.class, FileID.class, NftID.class, ProtoBytes.class, ProtoLong.class, ProtoString.class, ScheduleID.class, SlotKey.class, TokenID.class, TopicID.class, ContractID.class, PendingAirdropId.class, TimestampSeconds.class, ScheduledOrder.class, TssMessageMapKey.class, TssVoteMapKey.class, HintsPartyId.class, PreprocessingVoteId.class, NodeId.class, ConstructionNodeId.class, EvmHookSlotKey.class, HookId.class}, k2, n)) {
            case 0 -> {
                AccountID accountID = (AccountID)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.ACCOUNT_ID_KEY, (Object)accountID));
            }
            case 1 -> {
                EntityIDPair entityIDPair = (EntityIDPair)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.TOKEN_RELATIONSHIP_KEY, (Object)new TokenAssociation(entityIDPair.tokenId(), entityIDPair.accountId())));
            }
            case 2 -> {
                EntityNumber entityNumber = (EntityNumber)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.ENTITY_NUMBER_KEY, (Object)entityNumber.number()));
            }
            case 3 -> {
                FileID fileID = (FileID)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.FILE_ID_KEY, (Object)fileID));
            }
            case 4 -> {
                NftID nftID = (NftID)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.NFT_ID_KEY, (Object)nftID));
            }
            case 5 -> {
                ProtoBytes protoBytes = (ProtoBytes)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.PROTO_BYTES_KEY, (Object)protoBytes.value()));
            }
            case 6 -> {
                ProtoLong protoLong = (ProtoLong)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.PROTO_LONG_KEY, (Object)protoLong.value()));
            }
            case 7 -> {
                ProtoString protoString = (ProtoString)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.PROTO_STRING_KEY, (Object)protoString.value()));
            }
            case 8 -> {
                ScheduleID scheduleID = (ScheduleID)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.SCHEDULE_ID_KEY, (Object)scheduleID));
            }
            case 9 -> {
                SlotKey slotKey = (SlotKey)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.SLOT_KEY_KEY, (Object)slotKey));
            }
            case 10 -> {
                TokenID tokenID = (TokenID)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.TOKEN_ID_KEY, (Object)tokenID));
            }
            case 11 -> {
                TopicID topicID = (TopicID)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.TOPIC_ID_KEY, (Object)topicID));
            }
            case 12 -> {
                ContractID contractID = (ContractID)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.CONTRACT_ID_KEY, (Object)contractID));
            }
            case 13 -> {
                PendingAirdropId pendingAirdropId = (PendingAirdropId)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.PENDING_AIRDROP_ID_KEY, (Object)pendingAirdropId));
            }
            case 14 -> {
                TimestampSeconds timestampSeconds = (TimestampSeconds)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.TIMESTAMP_SECONDS_KEY, (Object)timestampSeconds));
            }
            case 15 -> {
                ScheduledOrder scheduledOrder = (ScheduledOrder)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.SCHEDULED_ORDER_KEY, (Object)scheduledOrder));
            }
            case 16 -> {
                TssMessageMapKey tssMessageMapKey = (TssMessageMapKey)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.TSS_MESSAGE_MAP_KEY, (Object)tssMessageMapKey));
            }
            case 17 -> {
                TssVoteMapKey tssVoteMapKey = (TssVoteMapKey)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.TSS_VOTE_MAP_KEY, (Object)tssVoteMapKey));
            }
            case 18 -> {
                HintsPartyId hintsPartyId = (HintsPartyId)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.HINTS_PARTY_ID_KEY, (Object)hintsPartyId));
            }
            case 19 -> {
                PreprocessingVoteId preprocessingVoteId = (PreprocessingVoteId)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.PREPROCESSING_VOTE_ID_KEY, (Object)preprocessingVoteId));
            }
            case 20 -> {
                NodeId nodeId = (NodeId)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.NODE_ID_KEY, (Object)nodeId));
            }
            case 21 -> {
                ConstructionNodeId constructionNodeId = (ConstructionNodeId)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.CONSTRUCTION_NODE_ID_KEY, (Object)constructionNodeId));
            }
            case 22 -> {
                EvmHookSlotKey evmHookSlotKey = (EvmHookSlotKey)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.EVM_HOOK_SLOT_KEY, (Object)evmHookSlotKey));
            }
            case 23 -> {
                HookId HookId = (HookId)k2;
                yield new MapChangeKey(new OneOf((Enum)MapChangeKey.KeyChoiceOneOfType.HOOK_ID_KEY, (Object)HookId));
            }
            default -> throw new IllegalStateException("Unrecognized key type " + key.getClass().getSimpleName());
        };
    }

    private static <V> MapChangeValue mapChangeValueFor(@NonNull V value) {
        V v = value;
        Objects.requireNonNull(v);
        V v2 = v;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Node.class, NodeId.class, Account.class, AccountID.class, Bytecode.class, File.class, Nft.class, ProtoString.class, Roster.class, Schedule.class, ScheduleID.class, ScheduleList.class, SlotValue.class, StakingNodeInfo.class, Token.class, TokenRelation.class, Topic.class, AccountPendingAirdrop.class, ScheduledCounts.class, ThrottleUsageSnapshots.class, TssMessageTransactionBody.class, TssVoteTransactionBody.class, TssEncryptionKeys.class, HintsKeySet.class, PreprocessingVote.class, RecordedHistorySignature.class, HistoryProofVote.class, ProofKeySet.class, CrsPublicationTransactionBody.class, EvmHookState.class, WrapsMessageHistory.class, RegisteredNode.class}, v2, n)) {
            case 0 -> {
                Node node = (Node)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.NODE_VALUE, (Object)node));
            }
            case 1 -> {
                NodeId nodeId = (NodeId)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.NODE_ID_VALUE, (Object)nodeId));
            }
            case 2 -> {
                Account account = (Account)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.ACCOUNT_VALUE, (Object)account));
            }
            case 3 -> {
                AccountID accountID = (AccountID)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.ACCOUNT_ID_VALUE, (Object)accountID));
            }
            case 4 -> {
                Bytecode bytecode = (Bytecode)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.BYTECODE_VALUE, (Object)bytecode));
            }
            case 5 -> {
                File file = (File)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.FILE_VALUE, (Object)file));
            }
            case 6 -> {
                Nft nft = (Nft)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.NFT_VALUE, (Object)nft));
            }
            case 7 -> {
                ProtoString protoString = (ProtoString)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.PROTO_STRING_VALUE, (Object)protoString));
            }
            case 8 -> {
                Roster roster = (Roster)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.ROSTER_VALUE, (Object)roster));
            }
            case 9 -> {
                Schedule schedule = (Schedule)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.SCHEDULE_VALUE, (Object)schedule));
            }
            case 10 -> {
                ScheduleID scheduleID = (ScheduleID)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.SCHEDULE_ID_VALUE, (Object)scheduleID));
            }
            case 11 -> {
                ScheduleList scheduleList = (ScheduleList)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.SCHEDULE_LIST_VALUE, (Object)scheduleList));
            }
            case 12 -> {
                SlotValue slotValue = (SlotValue)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.SLOT_VALUE_VALUE, (Object)slotValue));
            }
            case 13 -> {
                StakingNodeInfo stakingNodeInfo = (StakingNodeInfo)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.STAKING_NODE_INFO_VALUE, (Object)stakingNodeInfo));
            }
            case 14 -> {
                Token token = (Token)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.TOKEN_VALUE, (Object)token));
            }
            case 15 -> {
                TokenRelation tokenRelation = (TokenRelation)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.TOKEN_RELATION_VALUE, (Object)tokenRelation));
            }
            case 16 -> {
                Topic topic = (Topic)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.TOPIC_VALUE, (Object)topic));
            }
            case 17 -> {
                AccountPendingAirdrop accountPendingAirdrop = (AccountPendingAirdrop)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.ACCOUNT_PENDING_AIRDROP_VALUE, (Object)accountPendingAirdrop));
            }
            case 18 -> {
                ScheduledCounts scheduledCounts = (ScheduledCounts)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.SCHEDULED_COUNTS_VALUE, (Object)scheduledCounts));
            }
            case 19 -> {
                ThrottleUsageSnapshots throttleUsageSnapshots = (ThrottleUsageSnapshots)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.THROTTLE_USAGE_SNAPSHOTS_VALUE, (Object)throttleUsageSnapshots));
            }
            case 20 -> {
                TssMessageTransactionBody tssMessageTransactionBody = (TssMessageTransactionBody)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.TSS_MESSAGE_VALUE, (Object)tssMessageTransactionBody));
            }
            case 21 -> {
                TssVoteTransactionBody tssVoteTransactionBody = (TssVoteTransactionBody)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.TSS_VOTE_VALUE, (Object)tssVoteTransactionBody));
            }
            case 22 -> {
                TssEncryptionKeys tssEncryptionKeys = (TssEncryptionKeys)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.TSS_ENCRYPTION_KEYS_VALUE, (Object)tssEncryptionKeys));
            }
            case 23 -> {
                HintsKeySet hintsKeySet = (HintsKeySet)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.HINTS_KEY_SET_VALUE, (Object)hintsKeySet));
            }
            case 24 -> {
                PreprocessingVote preprocessingVote = (PreprocessingVote)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.PREPROCESSING_VOTE_VALUE, (Object)preprocessingVote));
            }
            case 25 -> {
                RecordedHistorySignature recordedHistorySignature = (RecordedHistorySignature)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.HISTORY_SIGNATURE_VALUE, (Object)recordedHistorySignature));
            }
            case 26 -> {
                HistoryProofVote historyProofVote = (HistoryProofVote)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.HISTORY_PROOF_VOTE_VALUE, (Object)historyProofVote));
            }
            case 27 -> {
                ProofKeySet proofKeySet = (ProofKeySet)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.PROOF_KEY_SET_VALUE, (Object)proofKeySet));
            }
            case 28 -> {
                CrsPublicationTransactionBody crsPublicationTransactionBody = (CrsPublicationTransactionBody)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.CRS_PUBLICATION_VALUE, (Object)crsPublicationTransactionBody));
            }
            case 29 -> {
                EvmHookState evmHookState = (EvmHookState)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.EVM_HOOK_STATE_VALUE, (Object)evmHookState));
            }
            case 30 -> {
                WrapsMessageHistory wrapsMessageHistory = (WrapsMessageHistory)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.WRAPS_MESSAGE_HISTORY_VALUE, (Object)wrapsMessageHistory));
            }
            case 31 -> {
                RegisteredNode registeredNode = (RegisteredNode)v2;
                yield new MapChangeValue(new OneOf((Enum)MapChangeValue.ValueChoiceOneOfType.REGISTERED_NODE_VALUE, (Object)registeredNode));
            }
            default -> throw new IllegalStateException("Unexpected value: " + value.getClass().getSimpleName());
        };
    }

    private static <V> OneOf<QueuePushChange.ValueOneOfType> queuePushChangeValueFor(@NonNull V value) {
        V v = value;
        Objects.requireNonNull(v);
        V v2 = v;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProtoBytes.class, TransactionReceiptEntries.class}, v2, n)) {
            case 0: {
                ProtoBytes protoBytesElement = (ProtoBytes)v2;
                return new OneOf((Enum)QueuePushChange.ValueOneOfType.PROTO_BYTES_ELEMENT, (Object)protoBytesElement.value());
            }
            case 1: {
                TransactionReceiptEntries transactionReceiptEntriesElement = (TransactionReceiptEntries)v2;
                return new OneOf((Enum)QueuePushChange.ValueOneOfType.TRANSACTION_RECEIPT_ENTRIES_ELEMENT, (Object)transactionReceiptEntriesElement);
            }
        }
        throw new IllegalArgumentException("Unknown value type " + value.getClass().getName());
    }
}

