/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees.context;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.fees.context.ChildFeeContext;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeCalculatorFactory;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.SimpleFeeCalculator;
import com.hedera.node.app.spi.store.ReadableStoreFactory;
import com.hedera.node.app.throttle.SynchronizedThrottleAccumulator;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;

public class IngestFeeContext
implements FeeContext {
    private final Instant consensusTime;
    private final TransactionInfo txInfo;
    private final Key payerKey;
    private final AccountID payerId;
    private final FeeManager feeManager;
    private final ReadableStoreFactory storeFactory;
    private final Configuration configuration;
    private final Authorizer authorizer;
    private final int numSignatures;
    private final TransactionDispatcher transactionDispatcher;
    private final HederaFunctionality function;
    private final SynchronizedThrottleAccumulator frontendThrottle;

    public IngestFeeContext(@NonNull Instant consensusTime, @NonNull TransactionInfo txInfo, @NonNull Key payerKey, @NonNull AccountID payerId, @NonNull FeeManager feeManager, @NonNull ReadableStoreFactory storeFactory, @NonNull Configuration configuration, @NonNull Authorizer authorizer, int numSignatures, TransactionDispatcher transactionDispatcher, SynchronizedThrottleAccumulator frontendThrottle) {
        this.consensusTime = consensusTime;
        this.txInfo = txInfo;
        this.payerKey = payerKey;
        this.payerId = payerId;
        this.feeManager = feeManager;
        this.storeFactory = storeFactory;
        this.configuration = configuration;
        this.authorizer = authorizer;
        this.numSignatures = numSignatures;
        this.transactionDispatcher = transactionDispatcher;
        this.function = Objects.requireNonNull(txInfo.functionality());
        this.frontendThrottle = Objects.requireNonNull(frontendThrottle);
    }

    @NonNull
    public AccountID payer() {
        return this.payerId;
    }

    @NonNull
    public TransactionBody body() {
        return this.txInfo.txBody();
    }

    @NonNull
    private FeeCalculator createFeeCalculator(@NonNull SubType subType) {
        int numVerifications = this.txInfo.signatureMap().sigPair().size();
        int signatureMapSize = SignatureMap.PROTOBUF.measureRecord((Object)this.txInfo.signatureMap());
        return this.feeManager.createFeeCalculator(this.txInfo.txBody(), this.payerKey, this.txInfo.functionality(), numVerifications, signatureMapSize, this.consensusTime, subType, false, this.storeFactory);
    }

    @NonNull
    public FeeCalculatorFactory feeCalculatorFactory() {
        return this::createFeeCalculator;
    }

    public SimpleFeeCalculator getSimpleFeeCalculator() {
        return this.feeManager.getSimpleFeeCalculator();
    }

    @NonNull
    public ReadableStoreFactory readableStoreFactory() {
        return this.storeFactory;
    }

    @NonNull
    public <T> T readableStore(@NonNull Class<T> storeInterface) {
        return (T)this.storeFactory.readableStore(storeInterface);
    }

    @NonNull
    public Configuration configuration() {
        return this.configuration;
    }

    @NonNull
    public Authorizer authorizer() {
        return this.authorizer;
    }

    public int numTxnSignatures() {
        return this.numSignatures;
    }

    public int numTxnBytes() {
        return (int)(this.txInfo.serializedSignedTx() != null ? this.txInfo.serializedSignedTx().length() : 0L);
    }

    public Fees dispatchComputeFees(@NonNull TransactionBody childTxBody, @NonNull AccountID syntheticPayerId) {
        return this.transactionDispatcher.dispatchComputeFees(new ChildFeeContext(this.feeManager, this, childTxBody, syntheticPayerId, true, this.authorizer, this.storeFactory, this.consensusTime, null, this.numSignatures, this.function));
    }

    public ExchangeRate activeRate() {
        return this.feeManager.getExchangeRateManager().activeRate(this.consensusTime);
    }

    public long getGasPriceInTinycents() {
        return this.feeManager.getGasPriceInTinyCents(this.consensusTime);
    }

    public HederaFunctionality functionality() {
        return this.function;
    }

    public int getHighVolumeThrottleUtilization(@NonNull HederaFunctionality functionality) {
        return this.frontendThrottle.getHighVolumeThrottleUtilization(functionality);
    }
}

