/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees.context;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import com.hedera.node.app.spi.workflows.QueryContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public final class SimpleFeeContextImpl
implements SimpleFeeContext {
    @Nullable
    private final FeeContext feeContext;
    @Nullable
    private final QueryContext queryContext;

    public SimpleFeeContextImpl(@Nullable FeeContext feeContext, @Nullable QueryContext queryContext) {
        if (feeContext != null && queryContext != null) {
            throw new IllegalArgumentException("Only one of feeContext or queryContext may be set");
        }
        this.feeContext = feeContext;
        this.queryContext = queryContext;
    }

    public int numTxnSignatures() {
        return this.feeContext == null ? 0 : this.feeContext.numTxnSignatures();
    }

    public int numTxnBytes() {
        return this.feeContext == null ? 0 : this.feeContext.numTxnBytes();
    }

    public HederaFunctionality functionality() {
        if (this.feeContext == null) {
            throw new UnsupportedOperationException("Not implemented for queries");
        }
        return Objects.requireNonNull(this.feeContext).functionality();
    }

    @Nullable
    public FeeContext feeContext() {
        return this.feeContext;
    }

    @Nullable
    public QueryContext queryContext() {
        return this.queryContext;
    }

    public int getHighVolumeThrottleUtilization(@NonNull HederaFunctionality functionality) {
        if (this.feeContext == null) {
            throw new UnsupportedOperationException("Not implemented for queries");
        }
        return this.feeContext.getHighVolumeThrottleUtilization(functionality);
    }
}

