/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl;

import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.SidecarFile;
import com.hedera.hapi.streams.SidecarMetadata;
import com.hedera.hapi.streams.SidecarType;
import com.hedera.hapi.streams.TransactionSidecarRecord;
import com.hedera.hapi.streams.schema.SidecarFileSchema;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.HashingOutputStream;

public final class WrappedRecordSidecarUtils {
    private WrappedRecordSidecarUtils() {
    }

    public static SidecarBundles buildSidecarBundles(@NonNull List<TransactionSidecarRecord> records, int maxSideCarSizeInBytes) {
        Objects.requireNonNull(records);
        ArrayList<SidecarFile> sidecarFiles = new ArrayList<SidecarFile>();
        ArrayList<SidecarMetadata> sidecarMetadata = new ArrayList<SidecarMetadata>();
        int id = 1;
        int bytesWritten = 0;
        ArrayList<TransactionSidecarRecord> currentFileRecords = new ArrayList<TransactionSidecarRecord>();
        EnumSet<SidecarType> currentTypes = EnumSet.noneOf(SidecarType.class);
        for (TransactionSidecarRecord record : records) {
            Bytes recordBytes = TransactionSidecarRecord.PROTOBUF.toBytes((Object)record);
            int recordLen = (int)recordBytes.length();
            if (!currentFileRecords.isEmpty() && bytesWritten + recordLen > maxSideCarSizeInBytes) {
                WrappedRecordSidecarUtils.emitSidecarBundle(sidecarFiles, sidecarMetadata, id, currentFileRecords, currentTypes);
                ++id;
                bytesWritten = 0;
                currentFileRecords.clear();
                currentTypes = EnumSet.noneOf(SidecarType.class);
            }
            currentFileRecords.add(record);
            bytesWritten += recordLen;
            switch ((TransactionSidecarRecord.SidecarRecordsOneOfType)record.sidecarRecords().kind()) {
                case ACTIONS: {
                    currentTypes.add(SidecarType.CONTRACT_ACTION);
                    break;
                }
                case BYTECODE: {
                    currentTypes.add(SidecarType.CONTRACT_BYTECODE);
                    break;
                }
                case STATE_CHANGES: {
                    currentTypes.add(SidecarType.CONTRACT_STATE_CHANGE);
                    break;
                }
            }
        }
        if (!currentFileRecords.isEmpty()) {
            WrappedRecordSidecarUtils.emitSidecarBundle(sidecarFiles, sidecarMetadata, id, currentFileRecords, currentTypes);
        }
        return new SidecarBundles(sidecarFiles, sidecarMetadata);
    }

    private static void emitSidecarBundle(List<SidecarFile> sidecarFiles, List<SidecarMetadata> sidecarMetadata, int id, List<TransactionSidecarRecord> currentFileRecords, Set<SidecarType> currentTypes) {
        SidecarFile file = new SidecarFile(new ArrayList<TransactionSidecarRecord>(currentFileRecords));
        Bytes fileHash = WrappedRecordSidecarUtils.sidecarFileHashAsWrittenByV6(currentFileRecords);
        sidecarFiles.add(file);
        sidecarMetadata.add(new SidecarMetadata(new HashObject(HashAlgorithm.SHA_384, (int)fileHash.length(), fileHash), id, List.copyOf(currentTypes)));
    }

    static Bytes sidecarFileHashAsWrittenByV6(@NonNull List<TransactionSidecarRecord> records) {
        Objects.requireNonNull(records);
        try {
            MessageDigest digest = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
            GZIPOutputStream gzip = new GZIPOutputStream(OutputStream.nullOutputStream());
            HashingOutputStream hashingOutputStream = new HashingOutputStream(digest, (OutputStream)gzip);
            WritableStreamingData outputStream = new WritableStreamingData((OutputStream)new BufferedOutputStream((OutputStream)hashingOutputStream));
            for (TransactionSidecarRecord record : records) {
                Bytes recordBytes = TransactionSidecarRecord.PROTOBUF.toBytes((Object)record);
                outputStream.writeVarInt(SidecarFileSchema.SIDECAR_RECORDS.number() << 3 | 2, false);
                outputStream.writeVarInt((int)recordBytes.length(), false);
                outputStream.writeBytes((RandomAccessData)recordBytes);
            }
            outputStream.close();
            gzip.close();
            return Bytes.wrap((byte[])hashingOutputStream.getDigest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to create SHA-384 message digest", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to compute sidecar file hash", e);
        }
    }

    public record SidecarBundles(List<SidecarFile> sidecarFiles, List<SidecarMetadata> sidecarMetadata) {
    }
}

