/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.steps;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hapi.utils.ethereum.EthTxSigs;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.contract.impl.handlers.EthereumTransactionHandler;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.records.CryptoUpdateStreamBuilder;
import com.hedera.node.app.signature.AppKeyVerifier;
import com.hedera.node.app.signature.impl.SignatureVerificationImpl;
import com.hedera.node.app.spi.signatures.SignatureVerification;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.handle.steps.ParentTxn;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class HollowAccountCompletions {
    private static final Logger logger = LogManager.getLogger(HollowAccountCompletions.class);
    private final EthereumTransactionHandler ethereumTransactionHandler;

    @Inject
    public HollowAccountCompletions(@NonNull EthereumTransactionHandler ethereumTransactionHandler) {
        this.ethereumTransactionHandler = Objects.requireNonNull(ethereumTransactionHandler);
    }

    public void completeHollowAccounts(@NonNull ParentTxn parentTxn, @NonNull Dispatch dispatch) {
        EthFinalization ethFinalization;
        Objects.requireNonNull(parentTxn);
        Objects.requireNonNull(dispatch);
        Set<Account> hollowAccounts = parentTxn.preHandleResult().getHollowAccounts();
        SignatureVerification maybeEthTxVerification = null;
        if (parentTxn.functionality() == HederaFunctionality.ETHEREUM_TRANSACTION && (ethFinalization = this.findEthHollowAccount(parentTxn)) != null) {
            hollowAccounts = new LinkedHashSet<Account>(parentTxn.preHandleResult().getHollowAccounts());
            hollowAccounts.add(ethFinalization.hollowAccount());
            maybeEthTxVerification = ethFinalization.ethVerification();
        }
        this.finalizeHollowAccounts(dispatch.handleContext(), hollowAccounts, dispatch.keyVerifier(), maybeEthTxVerification, parentTxn);
    }

    @Nullable
    private EthFinalization findEthHollowAccount(@NonNull ParentTxn parentTxn) {
        ReadableFileStore fileStore = (ReadableFileStore)parentTxn.readableStoreFactory().readableStore(ReadableFileStore.class);
        EthTxSigs maybeEthTxSigs = this.ethereumTransactionHandler.maybeEthTxSigsFor(parentTxn.txnInfo().txBody().ethereumTransactionOrThrow(), fileStore, parentTxn.config());
        if (maybeEthTxSigs != null) {
            Account maybeHollowAccount;
            HederaConfig config;
            Bytes alias = Bytes.wrap((byte[])maybeEthTxSigs.address());
            ReadableAccountStore accountStore = (ReadableAccountStore)parentTxn.readableStoreFactory().readableStore(ReadableAccountStore.class);
            AccountID maybeHollowAccountId = accountStore.getAccountIDByAlias((config = (HederaConfig)parentTxn.config().getConfigData(HederaConfig.class)).shard(), config.realm(), alias);
            if (maybeHollowAccountId != null && HapiUtils.isHollow((Account)(maybeHollowAccount = Objects.requireNonNull(accountStore.getAccountById(maybeHollowAccountId))))) {
                return new EthFinalization(maybeHollowAccount, new SignatureVerificationImpl(Key.newBuilder().ecdsaSecp256k1(Bytes.wrap((byte[])maybeEthTxSigs.publicKey())).build(), alias, true));
            }
        }
        return null;
    }

    private void finalizeHollowAccounts(@NonNull HandleContext context, @NonNull Set<Account> accounts, @NonNull AppKeyVerifier verifier, @Nullable SignatureVerification ethTxVerification, @NonNull ParentTxn parentTxn) {
        for (Account hollowAccount : accounts) {
            SignatureVerification verification;
            if (!parentTxn.stack().hasMoreSystemRecords()) break;
            if (hollowAccount.accountIdOrElse(AccountID.DEFAULT).equals((Object)AccountID.DEFAULT) || (verification = ethTxVerification != null && hollowAccount.alias().equals((Object)ethTxVerification.evmAlias()) ? ethTxVerification : Objects.requireNonNull(verifier.verificationFor(hollowAccount.alias()), "Required hollow account verified signature did not exist")).key() == null) continue;
            if (!KeyUtils.IMMUTABILITY_SENTINEL_KEY.equals((Object)hollowAccount.keyOrThrow())) {
                logger.error("Hollow account {} has a key other than the sentinel key", (Object)hollowAccount);
                return;
            }
            TransactionBody syntheticUpdateTxn = TransactionBody.newBuilder().cryptoUpdateAccount(CryptoUpdateTransactionBody.newBuilder().accountIDToUpdate(hollowAccount.accountId()).key(verification.key()).build()).build();
            CryptoUpdateStreamBuilder streamBuilder = (CryptoUpdateStreamBuilder)context.dispatch(DispatchOptions.independentDispatch((AccountID)context.payer(), (TransactionBody)syntheticUpdateTxn, CryptoUpdateStreamBuilder.class));
            streamBuilder.accountID(hollowAccount.accountIdOrThrow());
        }
    }

    private record EthFinalization(Account hollowAccount, SignatureVerification ethVerification) {
    }
}

