/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.concurrency.limits;

import io.helidon.common.concurrency.limits.IgnoreTaskException;
import io.helidon.common.concurrency.limits.LimitAlgorithmOutcomeImpl;
import io.helidon.common.concurrency.limits.LimitAlgorithmResultImpl;
import io.helidon.common.concurrency.limits.LimitException;
import java.util.Optional;
import java.util.concurrent.Callable;

public interface LimitAlgorithm {
    @Deprecated(since="4.3.0", forRemoval=true)
    default public <T> T invoke(Callable<T> callable) throws LimitException, Exception {
        Outcome outcome = this.tryAcquireOutcome();
        if (outcome instanceof Outcome.Accepted) {
            Outcome.Accepted accepted = (Outcome.Accepted)outcome;
            Token permit = accepted.token();
            try {
                T response = callable.call();
                permit.success();
                return response;
            }
            catch (IgnoreTaskException e) {
                permit.ignore();
                return e.handle();
            }
            catch (Exception e) {
                permit.dropped();
                throw e;
            }
        }
        throw new LimitException("No token available.");
    }

    default public <T> Result<T> call(Callable<T> callable) throws Exception {
        Outcome outcome = this.tryAcquireOutcome();
        if (outcome instanceof Outcome.Accepted) {
            Outcome.Accepted accepted = (Outcome.Accepted)outcome;
            Token permit = accepted.token();
            try {
                T response = callable.call();
                permit.success();
                return Result.create(response, outcome);
            }
            catch (IgnoreTaskException e) {
                permit.ignore();
                return Result.create(e.handle(), outcome);
            }
            catch (Exception e) {
                permit.dropped();
                throw e;
            }
        }
        throw new LimitException("No token available.");
    }

    @Deprecated(since="4.3.0", forRemoval=true)
    default public void invoke(Runnable runnable) throws LimitException, Exception {
        this.run(runnable);
    }

    default public Outcome run(Runnable runnable) throws Exception {
        Outcome outcome = this.tryAcquireOutcome();
        if (outcome instanceof Outcome.Accepted) {
            Outcome.Accepted accepted = (Outcome.Accepted)outcome;
            Token permit = accepted.token();
            try {
                runnable.run();
                permit.success();
                return outcome;
            }
            catch (IgnoreTaskException e) {
                permit.ignore();
                e.handle();
                return outcome;
            }
            catch (Exception e) {
                permit.dropped();
                throw e;
            }
        }
        throw new LimitException("No token available.");
    }

    @Deprecated(since="4.3.0", forRemoval=true)
    public Optional<Token> tryAcquire();

    default public Outcome tryAcquireOutcome() {
        return this.tryAcquireOutcome(true);
    }

    @Deprecated(since="4.3.0", forRemoval=true)
    public Optional<Token> tryAcquire(boolean var1);

    default public Outcome tryAcquireOutcome(boolean wait) {
        return LimitAlgorithmOutcomeImpl.create(this.tryAcquire(wait));
    }

    public static interface Outcome {
        public static Outcome immediateAcceptance(String originName, String algorithmType, Token token) {
            return LimitAlgorithmOutcomeImpl.immediateAcceptance(originName, algorithmType, token);
        }

        public static Outcome deferredAcceptance(String originName, String algorithmType, Token token, long waitStartNanos, long waitEndNanos) {
            return LimitAlgorithmOutcomeImpl.deferredAcceptance(originName, algorithmType, token, waitStartNanos, waitEndNanos);
        }

        public static Outcome immediateRejection(String originName, String algorithmType) {
            return LimitAlgorithmOutcomeImpl.immediateRejection(originName, algorithmType);
        }

        public static Outcome deferredRejection(String originName, String algorithmType, long waitStartNanos, long waitEndNanos) {
            return LimitAlgorithmOutcomeImpl.deferredRejection(originName, algorithmType, waitStartNanos, waitEndNanos);
        }

        public String originName();

        public String algorithmType();

        public Disposition disposition();

        public Timing timing();

        public static interface Deferred
        extends Outcome {
            public long waitStartNanoTime();

            public long waitEndNanoTime();
        }

        public static interface Accepted
        extends Outcome {
            public Token token();
        }

        public static enum Timing {
            IMMEDIATE,
            DEFERRED,
            UNKNOWN;

        }

        public static enum Disposition {
            ACCEPTED,
            REJECTED;

        }
    }

    public static interface Token {
        public void dropped();

        public void ignore();

        public void success();
    }

    public static interface Result<T> {
        public static <T> Result<T> create(T callableReturnValue, Outcome outcome) {
            return LimitAlgorithmResultImpl.create(callableReturnValue, outcome);
        }

        public T result();

        public Outcome outcome();
    }
}

