/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction0;
import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleCharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToCharFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleCharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.DoubleCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.factory.primitive.CharDoubleMaps;
import org.eclipse.collections.api.factory.primitive.DoubleCharMaps;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.map.primitive.DoubleCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleCharMap;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.DoubleCharPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableCharValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableDoubleKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableDoubleMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedDoubleCharMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableDoubleCharMap;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class DoubleCharHashMap
extends AbstractMutableCharValuesMap
implements MutableDoubleCharMap,
Externalizable,
MutableDoubleKeysMap {
    private static final char EMPTY_VALUE = '\u0000';
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private double[] keys;
    private char[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableCharValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public DoubleCharHashMap() {
        this.allocateTable(16);
    }

    public DoubleCharHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public DoubleCharHashMap(DoubleCharMap map) {
        if (map instanceof DoubleCharHashMap && ((DoubleCharHashMap)map).occupiedWithSentinels == 0) {
            DoubleCharHashMap hashMap = (DoubleCharHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static DoubleCharHashMap newWithKeysValues(double key1, char value1) {
        return new DoubleCharHashMap(1).withKeyValue(key1, value1);
    }

    public static DoubleCharHashMap newWithKeysValues(double key1, char value1, double key2, char value2) {
        return new DoubleCharHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static DoubleCharHashMap newWithKeysValues(double key1, char value1, double key2, char value2, double key3, char value3) {
        return new DoubleCharHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static DoubleCharHashMap newWithKeysValues(double key1, char value1, double key2, char value2, double key3, char value3, double key4, char value4) {
        return new DoubleCharHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableCharValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected char getEmptyValue() {
        return '\u0000';
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected char getValueAtIndex(int index) {
        return this.values[index];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleCharMap)) {
            return false;
        }
        DoubleCharMap other = (DoubleCharMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0) || other.containsKey(1.0)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0) || this.sentinelValues.zeroValue != other.getOrThrow(0.0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0) || this.sentinelValues.oneValue != other.getOrThrow(1.0))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleCharHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32) ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32) ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleCharHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(Double.doubleToLongBits(this.keys[i]) ^ Double.doubleToLongBits(this.keys[i]) >>> 32) ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0.0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1.0).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleCharHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableCharIterator charIterator() {
        return new InternalCharIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleCharHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, 0.0);
        Arrays.fill(this.values, '\u0000');
    }

    public void put(double key, char value) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, key) == 0) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(char value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(char value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(DoubleCharMap map) {
        map.forEachKeyValue(this::put);
    }

    public void updateValues(DoubleCharToCharFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleCharHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.keys[i], this.values[i]);
        }
    }

    @Override
    public void removeKey(double key) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(double key) {
        this.removeKey(key);
    }

    public char removeKeyIfAbsent(double key, char value) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            char oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            char oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            char oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public char getIfAbsentPut(double key, char value) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public char getAndPut(double key, char putValue, char defaultValue) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsZeroKey) {
                char existingValue = this.sentinelValues.zeroValue;
                this.sentinelValues.zeroValue = putValue;
                return existingValue;
            }
            this.addEmptyKeyValue(putValue);
            return defaultValue;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsOneKey) {
                char existingValue = this.sentinelValues.oneValue;
                this.sentinelValues.oneValue = putValue;
                return existingValue;
            }
            this.addRemovedKeyValue(putValue);
            return defaultValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            char existingValue = this.values[index];
            this.values[index] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    public char getIfAbsentPut(double key, CharFunction0 function) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.value();
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.value();
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        char value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> char getIfAbsentPutWith(double key, CharFunction<? super P> function, P parameter) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.charValueOf(parameter);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value = function.charValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.charValueOf(parameter);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value = function.charValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        char value = function.charValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public char getIfAbsentPutWithKey(double key, DoubleToCharFunction function) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            char value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                char value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            char value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        char value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public char addToValue(double key, char toBeAdded) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (char)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (char)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            int n = index;
            this.values[n] = (char)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(double key, char value, int index) {
        if (Double.compare(this.keys[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1.0;
        this.values[index] = '\u0000';
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        double[] copy = new double[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    public char updateValue(double key, char initialValueIfAbsent, CharToCharFunction function) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableCharValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        char value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public DoubleCharHashMap withKeyValue(double key1, char value1) {
        this.put(key1, value1);
        return this;
    }

    public DoubleCharHashMap withKeysValues(double key1, char value1, double key2, char value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public DoubleCharHashMap withKeysValues(double key1, char value1, double key2, char value2, double key3, char value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public DoubleCharHashMap withKeysValues(double key1, char value1, double key2, char value2, double key3, char value3, double key4, char value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public DoubleCharHashMap withoutKey(double key) {
        this.removeKey(key);
        return this;
    }

    public DoubleCharHashMap withoutAllKeys(DoubleIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    public MutableDoubleCharMap asUnmodifiable() {
        return new UnmodifiableDoubleCharMap(this);
    }

    public MutableDoubleCharMap asSynchronized() {
        return new SynchronizedDoubleCharMap(this);
    }

    public ImmutableDoubleCharMap toImmutable() {
        return DoubleCharMaps.immutable.ofAll((DoubleCharMap)this);
    }

    public char get(double key) {
        return this.getIfAbsent(key, '\u0000');
    }

    public char getIfAbsent(double key, char ifAbsent) {
        if (DoubleCharHashMap.isEmptyKey(key) || DoubleCharHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private char getForSentinel(double key, char ifAbsent) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private char slowGetIfAbsent(double key, char ifAbsent) {
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private char fastGetIfAbsent(double key, char ifAbsent) {
        int index = this.mask((int)key);
        for (int i = 0; i < 4; ++i) {
            double keyAtIndex = this.keys[index];
            if (Double.compare(keyAtIndex, key) == 0) {
                return this.values[index];
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private char slowGetIfAbsentTwo(double key, char ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public char getOrThrow(double key) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (DoubleCharHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(double key) {
        if (DoubleCharHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (DoubleCharHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Double.compare(this.keys[this.probe(key)], key) == 0;
    }

    @Override
    public void forEachKey(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(DoubleCharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleCharHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public boolean allSatisfyKeyValue(DoubleCharPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0, this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    public LazyDoubleIterable keysView() {
        return new KeysView();
    }

    public RichIterable<DoubleCharPair> keyValuesView() {
        return new KeyValuesView();
    }

    public MutableCharDoubleMap flipUniqueValues() {
        MutableCharDoubleMap result = CharDoubleMaps.mutable.empty();
        this.forEachKeyValue((DoubleCharProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    public DoubleCharHashMap select(DoubleCharPredicate predicate) {
        DoubleCharHashMap result = new DoubleCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleCharHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public DoubleCharHashMap reject(DoubleCharPredicate predicate) {
        DoubleCharHashMap result = new DoubleCharHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleCharHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeDouble(0.0);
                out.writeChar(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeDouble(1.0);
                out.writeChar(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleCharHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeDouble(this.keys[i]);
            out.writeChar(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readDouble(), in.readChar());
        }
    }

    public boolean trimToSize() {
        int newCapacity = this.smallestPowerOfTwoGreaterThan(this.size());
        if (this.keys.length > newCapacity) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    @Deprecated
    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        double[] old = this.keys;
        char[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!DoubleCharHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(double element) {
        int index = this.mask((int)element);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, element) == 0 || Double.compare(keyAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(keyAtIndex, 1.0) == 0 ? index : -1;
        for (int i = 1; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (Double.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(double element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            double keyAtIndex = this.keys[nextIndex];
            if (Double.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(double element, int removedIndex) {
        int nextIndex = (int)SpreadFunctions.doubleSpreadOne(element);
        int spreadTwo = (int)Long.reverse(SpreadFunctions.doubleSpreadTwo(element)) | 1;
        double keyAtIndex;
        while (Double.compare(keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)], element) != 0) {
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new double[sizeToAllocate];
        this.values = new char[sizeToAllocate];
    }

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !DoubleCharHashMap.isEmptyKey(key) && !DoubleCharHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !DoubleCharHashMap.isEmptyKey(this.keys[index]) && !DoubleCharHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    public MutableDoubleSet keySet() {
        return new KeySet();
    }

    public MutableCharCollection values() {
        return new ValuesCollection();
    }

    private class InternalCharIterator
    implements MutableCharIterator {
        private int count;
        private int position;
        private double lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleCharHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleCharHashMap.this.containsKey(0.0)) {
                    this.lastKey = 0.0;
                    return DoubleCharHashMap.this.get(0.0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleCharHashMap.this.containsKey(1.0)) {
                    this.lastKey = 1.0;
                    return DoubleCharHashMap.this.get(1.0);
                }
            }
            double[] keys = DoubleCharHashMap.this.keys;
            while (!DoubleCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            char result = DoubleCharHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            DoubleCharHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyDoubleIterable {
        private KeysView() {
        }

        public DoubleIterator doubleIterator() {
            return new UnmodifiableDoubleIterator((DoubleIterator)new KeySetIterator());
        }

        public void each(DoubleProcedure procedure) {
            DoubleCharHashMap.this.forEachKey(procedure);
        }
    }

    private class KeyValuesView
    extends AbstractLazyIterable<DoubleCharPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super DoubleCharPair> procedure) {
            if (DoubleCharHashMap.this.sentinelValues != null) {
                if (DoubleCharHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0, DoubleCharHashMap.this.sentinelValues.zeroValue));
                }
                if (DoubleCharHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0, DoubleCharHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < DoubleCharHashMap.this.keys.length; ++i) {
                if (!DoubleCharHashMap.isNonSentinel(DoubleCharHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(DoubleCharHashMap.this.keys[i], DoubleCharHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super DoubleCharPair> objectIntProcedure) {
            int index = 0;
            if (DoubleCharHashMap.this.sentinelValues != null) {
                if (DoubleCharHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0.0, DoubleCharHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (DoubleCharHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1.0, DoubleCharHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < DoubleCharHashMap.this.keys.length; ++i) {
                if (!DoubleCharHashMap.isNonSentinel(DoubleCharHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(DoubleCharHashMap.this.keys[i], DoubleCharHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super DoubleCharPair, ? super P> procedure, P parameter) {
            if (DoubleCharHashMap.this.sentinelValues != null) {
                if (DoubleCharHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0, DoubleCharHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (DoubleCharHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0, DoubleCharHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < DoubleCharHashMap.this.keys.length; ++i) {
                if (!DoubleCharHashMap.isNonSentinel(DoubleCharHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(DoubleCharHashMap.this.keys[i], DoubleCharHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<DoubleCharPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<DoubleCharPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public DoubleCharPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (DoubleCharHashMap.this.containsKey(0.0)) {
                        return PrimitiveTuples.pair(0.0, DoubleCharHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (DoubleCharHashMap.this.containsKey(1.0)) {
                        return PrimitiveTuples.pair(1.0, DoubleCharHashMap.this.sentinelValues.oneValue);
                    }
                }
                double[] keys = DoubleCharHashMap.this.keys;
                while (!DoubleCharHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                DoubleCharPair result = PrimitiveTuples.pair(keys[this.position], DoubleCharHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != DoubleCharHashMap.this.size();
            }
        }
    }

    private class KeySet
    extends AbstractMutableDoubleKeySet {
        private KeySet() {
        }

        @Override
        protected MutableDoubleKeysMap getOuter() {
            return DoubleCharHashMap.this;
        }

        @Override
        protected AbstractMutableCharValuesMap.SentinelValues getSentinelValues() {
            return DoubleCharHashMap.this.sentinelValues;
        }

        @Override
        protected double getKeyAtIndex(int index) {
            return DoubleCharHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return DoubleCharHashMap.this.keys.length;
        }

        public MutableDoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(DoubleIterable source) {
            int oldSize = DoubleCharHashMap.this.size();
            Object sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            DoubleCharHashMap retained = DoubleCharHashMap.this.select((arg_0, arg_1) -> KeySet.lambda$retainAll$eb5f342d$1((DoubleSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                DoubleCharHashMap.this.keys = retained.keys;
                DoubleCharHashMap.this.values = retained.values;
                DoubleCharHashMap.this.sentinelValues = retained.sentinelValues;
                DoubleCharHashMap.this.occupiedWithData = retained.occupiedWithData;
                DoubleCharHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(double ... source) {
            return this.retainAll(DoubleHashSet.newSetWith(source));
        }

        public DoubleSet freeze() {
            DoubleCharHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (DoubleCharHashMap.this.sentinelValues != null) {
                containsZeroKey = DoubleCharHashMap.this.sentinelValues.containsZeroKey;
                containsOneKey = DoubleCharHashMap.this.sentinelValues.containsOneKey;
            }
            return new ImmutableDoubleMapKeySet(DoubleCharHashMap.this.keys, DoubleCharHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        public MutableDoubleSet newEmpty() {
            return new DoubleHashSet();
        }

        private static /* synthetic */ boolean lambda$retainAll$eb5f342d$1(DoubleSet sourceSet, double key, char value) {
            return sourceSet.contains(key);
        }
    }

    private class ValuesCollection
    extends AbstractMutableCharValuesMap.AbstractCharValuesCollection {
        private ValuesCollection() {
        }

        public MutableCharIterator charIterator() {
            return DoubleCharHashMap.this.charIterator();
        }

        public boolean remove(char item) {
            int oldSize = DoubleCharHashMap.this.size();
            if (DoubleCharHashMap.this.sentinelValues != null && DoubleCharHashMap.this.sentinelValues.containsZeroKey && item == DoubleCharHashMap.this.sentinelValues.zeroValue) {
                DoubleCharHashMap.this.removeKey(0.0);
            }
            if (DoubleCharHashMap.this.sentinelValues != null && DoubleCharHashMap.this.sentinelValues.containsOneKey && item == DoubleCharHashMap.this.sentinelValues.oneValue) {
                DoubleCharHashMap.this.removeKey(1.0);
            }
            for (int i = 0; i < DoubleCharHashMap.this.keys.length; ++i) {
                if (!DoubleCharHashMap.isNonSentinel(DoubleCharHashMap.this.keys[i]) || item != DoubleCharHashMap.this.values[i]) continue;
                DoubleCharHashMap.this.removeKey(DoubleCharHashMap.this.keys[i]);
            }
            return oldSize != DoubleCharHashMap.this.size();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = DoubleCharHashMap.this.size();
            Object sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            DoubleCharHashMap retained = DoubleCharHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$b1a18fa3$1((CharSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                DoubleCharHashMap.this.keys = retained.keys;
                DoubleCharHashMap.this.values = retained.values;
                DoubleCharHashMap.this.sentinelValues = retained.sentinelValues;
                DoubleCharHashMap.this.occupiedWithData = retained.occupiedWithData;
                DoubleCharHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public MutableCharCollection newEmpty() {
            return new CharHashBag();
        }

        private static /* synthetic */ boolean lambda$retainAll$b1a18fa3$1(CharSet sourceSet, double key, char value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySetIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;
        private double lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleCharHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleCharHashMap.this.containsKey(0.0)) {
                    this.lastKey = 0.0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleCharHashMap.this.containsKey(1.0)) {
                    this.lastKey = 1.0;
                    return this.lastKey;
                }
            }
            double[] keys = DoubleCharHashMap.this.keys;
            while (!DoubleCharHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            DoubleCharHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

