/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.platformstate;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.PbjConverters;
import org.hiero.consensus.platformstate.PlatformStateAccessor;
import org.hiero.consensus.platformstate.V0540PlatformStateSchema;

public class ReadablePlatformStateStore
implements PlatformStateAccessor {
    private final ReadableSingletonState<PlatformState> state;

    public ReadablePlatformStateStore(@NonNull ReadableStates readableStates) {
        this.state = Objects.requireNonNull(readableStates).getSingleton(V0540PlatformStateSchema.PLATFORM_STATE_STATE_ID);
    }

    @Override
    @NonNull
    public SemanticVersion getCreationSoftwareVersion() {
        return this.stateOrThrow().creationSoftwareVersionOrThrow();
    }

    @Override
    public long getRound() {
        ConsensusSnapshot consensusSnapshot = this.stateOrThrow().consensusSnapshot();
        if (consensusSnapshot == null) {
            return 0L;
        }
        return consensusSnapshot.round();
    }

    @Override
    @Nullable
    public Hash getLegacyRunningEventHash() {
        Bytes hash = this.stateOrThrow().legacyRunningEventHash();
        return hash.length() == 0L ? null : new Hash(hash);
    }

    @Override
    @Nullable
    public Instant getConsensusTimestamp() {
        ConsensusSnapshot consensusSnapshot = this.stateOrThrow().consensusSnapshot();
        if (consensusSnapshot == null) {
            return null;
        }
        return PbjConverters.fromPbjTimestamp((Timestamp)consensusSnapshot.consensusTimestamp());
    }

    @Override
    public long getAncientThreshold() {
        ConsensusSnapshot consensusSnapshot = this.stateOrThrow().consensusSnapshot();
        Objects.requireNonNull(consensusSnapshot, "No minimum judge info found in state for round, snapshot is null");
        List minimumJudgeInfos = consensusSnapshot.minimumJudgeInfoList();
        if (minimumJudgeInfos.isEmpty()) {
            if (consensusSnapshot.round() == 0L) {
                return 1L;
            }
            throw new IllegalStateException("No minimum judge info found in state for round " + consensusSnapshot.round() + ", list is empty");
        }
        return ((MinimumJudgeInfo)minimumJudgeInfos.getFirst()).minimumJudgeBirthRound();
    }

    @Override
    public int getRoundsNonAncient() {
        return this.stateOrThrow().roundsNonAncient();
    }

    @Override
    @Nullable
    public ConsensusSnapshot getSnapshot() {
        return this.stateOrThrow().consensusSnapshot();
    }

    @Override
    @Nullable
    public Instant getFreezeTime() {
        return PbjConverters.fromPbjTimestamp((Timestamp)this.stateOrThrow().freezeTime());
    }

    @Override
    @Nullable
    public Instant getLastFrozenTime() {
        return PbjConverters.fromPbjTimestamp((Timestamp)this.stateOrThrow().lastFrozenTime());
    }

    @Override
    public long getLatestFreezeRound() {
        return this.stateOrThrow().latestFreezeRound();
    }

    @NonNull
    private PlatformState stateOrThrow() {
        return Objects.requireNonNull((PlatformState)this.state.get());
    }
}

