/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.swirlds.base.units.TimeUnit;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import org.hiero.consensus.metrics.RunningAverageMetric;
import org.hiero.consensus.metrics.SpeedometerMetric;

public class SignedStateMetrics {
    private static final String CATEGORY = "platform";
    private static final String MILLISECONDS = TimeUnit.UNIT_MILLISECONDS.getAbbreviation();
    private static final RunningAverageMetric.Config UNSIGNED_STATES_CONFIG = new RunningAverageMetric.Config("platform", "unsignedStates").withDescription("Average Number Of Unsigned States Awaiting Signatures").withUnit("count").withFormat("%,10.2f");
    private final RunningAverageMetric unsignedStates;
    private static final RunningAverageMetric.Config AVERAGE_TIME_TO_FULLY_SIGN_STATE = new RunningAverageMetric.Config("platform", "averageTimeToFullySignState").withDescription("The average time spent waiting for enough state signatures to fully sign a state.").withUnit(MILLISECONDS).withFormat("%,10.2f");
    private final RunningAverageMetric averageTimeToFullySignState;
    private static final Counter.Config TOTAL_NEVER_SIGNED_STATES_CONFIG = new Counter.Config("platform", "totalNeverSignedStates").withDescription("total number of states that did not receive enough signatures in the allowed time").withUnit("count");
    private final Counter totalNeverSignedStates;
    private static final SpeedometerMetric.Config STATES_SIGNED_PER_SECOND_CONFIG = new SpeedometerMetric.Config("platform", "sstatesSigned_per_sec").withDescription("the number of states completely signed per second").withFormat("%,16.2f").withUnit("hz");
    private final SpeedometerMetric statesSignedPerSecond;
    private static final SpeedometerMetric.Config STATE_SIGNATURES_GATHERED_PER_SECOND_CONFIG = new SpeedometerMetric.Config("platform", "stateSignaturesGathered_per_sec").withDescription("the number of state signatures gathered from other nodes per second").withFormat("%,16.2f").withUnit("hz");
    private final SpeedometerMetric stateSignaturesGatheredPerSecond;
    private static final RunningAverageMetric.Config STATE_SIGNATURE_AGE_CONFIG = new RunningAverageMetric.Config("platform", "stateSignatureAge").withDescription("the average difference in round number between state signatures and the most recent immutable state. Negative numbers meanthe are being received early, large positive numbers mean signatures are being received late.").withFormat("%,10.3f").withUnit("rounds");
    private final RunningAverageMetric stateSignatureAge;

    public RunningAverageMetric getUnsignedStatesMetric() {
        return this.unsignedStates;
    }

    public RunningAverageMetric getAverageTimeToFullySignStateMetric() {
        return this.averageTimeToFullySignState;
    }

    public Counter getTotalUnsignedStatesMetric() {
        return this.totalNeverSignedStates;
    }

    public SpeedometerMetric getStatesSignedPerSecondMetric() {
        return this.statesSignedPerSecond;
    }

    public SpeedometerMetric getStateSignaturesGatheredPerSecondMetric() {
        return this.stateSignaturesGatheredPerSecond;
    }

    public RunningAverageMetric getStateSignatureAge() {
        return this.stateSignatureAge;
    }

    public SignedStateMetrics(Metrics metrics) {
        this.unsignedStates = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)UNSIGNED_STATES_CONFIG);
        this.averageTimeToFullySignState = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVERAGE_TIME_TO_FULLY_SIGN_STATE);
        this.totalNeverSignedStates = (Counter)metrics.getOrCreate((MetricConfig)TOTAL_NEVER_SIGNED_STATES_CONFIG);
        this.statesSignedPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)STATES_SIGNED_PER_SECOND_CONFIG);
        this.stateSignaturesGatheredPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)STATE_SIGNATURES_GATHERED_PER_SECOND_CONFIG);
        this.stateSignatureAge = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)STATE_SIGNATURE_AGE_CONFIG);
    }
}

