/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hbarapprove;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.token.CryptoAllowance;
import com.hedera.hapi.node.token.CryptoApproveAllowanceTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hbarapprove.HbarApproveCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HbarApproveTranslator
extends AbstractCallTranslator<HasCallAttempt> {
    public static final SystemContractMethod HBAR_APPROVE_PROXY = SystemContractMethod.declare("hbarApprove(address,int256)", "(int64)").withVia(SystemContractMethod.CallVia.PROXY).withCategories(SystemContractMethod.Category.APPROVAL);
    public static final SystemContractMethod HBAR_APPROVE = SystemContractMethod.declare("hbarApprove(address,address,int256)", "(int64)").withCategories(SystemContractMethod.Category.APPROVAL);

    @Inject
    public HbarApproveTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HAS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(HBAR_APPROVE, HBAR_APPROVE_PROXY);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(HBAR_APPROVE, HBAR_APPROVE_PROXY);
    }

    @Override
    public Call callFrom(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        if (attempt.isSelector(HBAR_APPROVE)) {
            return new HbarApproveCall(attempt, this.bodyForApprove(attempt));
        }
        if (attempt.isSelector(HBAR_APPROVE_PROXY)) {
            return new HbarApproveCall(attempt, this.bodyForApproveProxy(attempt));
        }
        return null;
    }

    @NonNull
    private TransactionBody bodyForApprove(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        Tuple call = HBAR_APPROVE.decodeCall(attempt.inputBytes());
        AccountID owner = attempt.addressIdConverter().convert((Address)call.get(0));
        AccountID spender = attempt.addressIdConverter().convert((Address)call.get(1));
        return this.bodyOf(this.cryptoApproveTransactionBody(owner, spender, (BigInteger)call.get(2)));
    }

    @NonNull
    private TransactionBody bodyForApproveProxy(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        Tuple call = HBAR_APPROVE_PROXY.decodeCall(attempt.inputBytes());
        AccountID owner = attempt.redirectAccount() == null ? attempt.senderId() : attempt.redirectAccount().accountId();
        AccountID spender = attempt.addressIdConverter().convert((Address)call.get(0));
        return this.bodyOf(this.cryptoApproveTransactionBody(owner, spender, (BigInteger)call.get(1)));
    }

    @NonNull
    private CryptoApproveAllowanceTransactionBody cryptoApproveTransactionBody(@NonNull AccountID owner, @NonNull AccountID operatorId, @NonNull BigInteger amount) {
        Objects.requireNonNull(owner);
        Objects.requireNonNull(operatorId);
        Objects.requireNonNull(amount);
        return CryptoApproveAllowanceTransactionBody.newBuilder().cryptoAllowances(new CryptoAllowance[]{CryptoAllowance.newBuilder().owner(owner).spender(operatorId).amount(amount.longValueExact()).build()}).build();
    }

    @NonNull
    private TransactionBody bodyOf(@NonNull CryptoApproveAllowanceTransactionBody approveAllowanceTransactionBody) {
        return TransactionBody.newBuilder().cryptoApproveAllowance(approveAllowanceTransactionBody).build();
    }
}

