/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts;

import com.esaulpaugh.headlong.abi.Function;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallAttemptOptions;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

public class HtsCallAttempt
extends AbstractCallAttempt<HtsCallAttempt> {
    public static final Function REDIRECT_FOR_TOKEN = new Function("redirectForToken(address,bytes)");
    private final AccountID authorizingId;
    @Nullable
    private final Token redirectToken;

    public HtsCallAttempt(@NonNull Bytes input, @NonNull CallAttemptOptions<HtsCallAttempt> options) {
        super(input, options, REDIRECT_FOR_TOKEN);
        this.redirectToken = this.isRedirect() ? this.linkedToken(this.redirectAddress) : null;
        this.authorizingId = options.authorizingAddress() != this.senderAddress() ? this.addressIdConverter().convertSender(options.authorizingAddress()) : this.senderId;
    }

    @Override
    protected SystemContractMethod.SystemContract systemContractKind() {
        return SystemContractMethod.SystemContract.HTS;
    }

    @Override
    protected HtsCallAttempt self() {
        return this;
    }

    @Nullable
    public Token redirectToken() {
        if (!this.isRedirect()) {
            throw new IllegalStateException("Not a token redirect");
        }
        return this.redirectToken;
    }

    @Nullable
    public TokenID redirectTokenId() {
        if (!this.isRedirect()) {
            throw new IllegalStateException("Not a token redirect");
        }
        return this.redirectToken == null ? null : this.redirectToken.tokenId();
    }

    @Nullable
    public TokenType redirectTokenType() {
        if (!this.isRedirect()) {
            throw new IllegalStateException("Not a token redirect");
        }
        return this.redirectToken == null ? null : this.redirectToken.tokenType();
    }

    @Nullable
    public Token linkedToken(@NonNull Address tokenAddress) {
        Objects.requireNonNull(tokenAddress);
        return this.linkedToken(tokenAddress.toArray());
    }

    @Nullable
    public Token linkedToken(@NonNull byte[] evmAddress) {
        Objects.requireNonNull(evmAddress);
        if (ConversionUtils.isLongZeroAddress(evmAddress)) {
            return this.enhancement().nativeOperations().getToken(this.nativeOperations().entityIdFactory().newTokenId(ConversionUtils.numberOfLongZero(evmAddress)));
        }
        return null;
    }

    public AccountID authorizingId() {
        return this.authorizingId;
    }
}

