/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.totalsupply;

import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.totalsupply.TotalSupplyCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TotalSupplyTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod TOTAL_SUPPLY = SystemContractMethod.declare("totalSupply()", "(int)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ERC20, SystemContractMethod.Category.ERC721, SystemContractMethod.Category.TOKEN_QUERY);

    @Inject
    public TotalSupplyTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(TOTAL_SUPPLY);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        return attempt.isMethod(TOTAL_SUPPLY);
    }

    public TotalSupplyCall callFrom(@NonNull HtsCallAttempt attempt) {
        return new TotalSupplyCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.redirectToken());
    }
}

