/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.FractionalFee;
import com.hedera.hapi.node.transaction.RoyaltyFee;
import com.hedera.node.app.hapi.utils.InvalidTransactionException;
import com.hedera.node.app.hapi.utils.ValidationUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenExpiryWrapper;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenKeyWrapper;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import java.util.List;

public class TokenCreateWrapper {
    private final boolean isFungible;
    private final String name;
    private final String symbol;
    private final AccountID treasury;
    private final boolean isSupplyTypeFinite;
    private final long initSupply;
    private final int decimals;
    private final long maxSupply;
    private final String memo;
    private final boolean isFreezeDefault;
    private final List<TokenKeyWrapper> tokenKeys;
    private final TokenExpiryWrapper expiry;
    private List<FixedFeeWrapper> fixedFees;
    private List<FractionalFeeWrapper> fractionalFees;
    private List<RoyaltyFeeWrapper> royaltyFees;
    private Bytes metadata;

    public TokenCreateWrapper(boolean isFungible, String tokenName, String tokenSymbol, AccountID tokenTreasury, String memo, Boolean isSupplyTypeFinite, long initSupply, int decimals, long maxSupply, Boolean isFreezeDefault, List<TokenKeyWrapper> tokenKeys, TokenExpiryWrapper tokenExpiry) {
        this.isFungible = isFungible;
        this.name = tokenName;
        this.symbol = tokenSymbol;
        this.treasury = tokenTreasury;
        this.memo = memo;
        this.isSupplyTypeFinite = isSupplyTypeFinite;
        this.initSupply = initSupply;
        this.decimals = decimals;
        this.maxSupply = maxSupply;
        this.isFreezeDefault = isFreezeDefault;
        this.tokenKeys = tokenKeys;
        this.expiry = tokenExpiry;
        this.fixedFees = List.of();
        this.fractionalFees = List.of();
        this.royaltyFees = List.of();
        this.metadata = Bytes.EMPTY;
    }

    public boolean isFungible() {
        return this.isFungible;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public AccountID getTreasury() {
        return this.treasury;
    }

    public boolean isSupplyTypeFinite() {
        return this.isSupplyTypeFinite;
    }

    public long getInitSupply() {
        return this.initSupply;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public long getMaxSupply() {
        return this.maxSupply;
    }

    public String getMemo() {
        return this.memo;
    }

    public boolean isFreezeDefault() {
        return this.isFreezeDefault;
    }

    public List<TokenKeyWrapper> getTokenKeys() {
        return this.tokenKeys;
    }

    public TokenExpiryWrapper getExpiry() {
        return this.expiry;
    }

    public Bytes getMetadata() {
        return this.metadata;
    }

    public List<FixedFeeWrapper> getFixedFees() {
        return this.fixedFees;
    }

    public List<FractionalFeeWrapper> getFractionalFees() {
        return this.fractionalFees;
    }

    public List<RoyaltyFeeWrapper> getRoyaltyFees() {
        return this.royaltyFees;
    }

    public void setMetadata(Bytes metadata) {
        this.metadata = metadata;
    }

    public void setFixedFees(List<FixedFeeWrapper> fixedFees) {
        this.fixedFees = fixedFees;
    }

    public void setFractionalFees(List<FractionalFeeWrapper> fractionalFees) {
        this.fractionalFees = fractionalFees;
    }

    public void setRoyaltyFees(List<RoyaltyFeeWrapper> royaltyFees) {
        this.royaltyFees = royaltyFees;
    }

    public void setAllInheritedKeysTo(Key senderKey) {
        for (TokenKeyWrapper tokenKey : this.tokenKeys) {
            if (!tokenKey.key().isShouldInheritAccountKeySet()) continue;
            tokenKey.key().setInheritedKey(senderKey);
        }
    }

    public record RoyaltyFeeWrapper(long numerator, long denominator, FixedFeeWrapper fallbackFixedFee, AccountID feeCollector) {
        public CustomFee asGrpc() {
            RoyaltyFee.Builder royaltyFeeBuilder = RoyaltyFee.newBuilder().exchangeValueFraction(Fraction.newBuilder().numerator(this.numerator).denominator(this.denominator).build());
            if (this.fallbackFixedFee != null) {
                ValidationUtils.validateTrue((this.fallbackFixedFee.getFixedFeePayment() != FixedFeeWrapper.FixedFeePayment.INVALID_PAYMENT ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FAIL_INVALID);
                royaltyFeeBuilder.fallbackFee(this.fallbackFixedFee.asBuilder().build());
            }
            CustomFee.Builder customFeeBuilder = CustomFee.newBuilder().royaltyFee(royaltyFeeBuilder.build());
            if (this.feeCollector != null) {
                customFeeBuilder.feeCollectorAccountId(this.feeCollector);
            }
            return customFeeBuilder.build();
        }
    }

    public record FractionalFeeWrapper(long numerator, long denominator, long minimumAmount, long maximumAmount, boolean netOfTransfers, AccountID feeCollector) {
        public CustomFee asGrpc() {
            CustomFee.Builder feeBuilder = CustomFee.newBuilder().fractionalFee(FractionalFee.newBuilder().fractionalAmount(Fraction.newBuilder().numerator(this.numerator).denominator(this.denominator).build()).minimumAmount(this.minimumAmount).maximumAmount(this.maximumAmount).netOfTransfers(this.netOfTransfers).build());
            if (this.feeCollector != null) {
                feeBuilder.feeCollectorAccountId(this.feeCollector);
            }
            return feeBuilder.build();
        }
    }

    public static final class FixedFeeWrapper {
        private final long amount;
        private final TokenID tokenID;
        private final boolean useHbarsForPayment;
        private final boolean useCurrentTokenForPayment;
        private final AccountID feeCollector;
        private final FixedFeePayment fixedFeePayment;

        public FixedFeeWrapper(long amount, TokenID tokenID, boolean useHbarsForPayment, boolean useCurrentTokenForPayment, AccountID feeCollector) {
            this.amount = amount;
            this.tokenID = tokenID;
            this.useHbarsForPayment = useHbarsForPayment;
            this.useCurrentTokenForPayment = useCurrentTokenForPayment;
            this.feeCollector = feeCollector;
            this.fixedFeePayment = this.setFixedFeePaymentType();
        }

        private FixedFeePayment setFixedFeePaymentType() {
            if (this.tokenID != null) {
                return !this.useHbarsForPayment && !this.useCurrentTokenForPayment ? FixedFeePayment.USE_EXISTING_FUNGIBLE_TOKEN : FixedFeePayment.INVALID_PAYMENT;
            }
            if (this.useCurrentTokenForPayment) {
                return !this.useHbarsForPayment ? FixedFeePayment.USE_CURRENTLY_CREATED_TOKEN : FixedFeePayment.INVALID_PAYMENT;
            }
            return this.useHbarsForPayment ? FixedFeePayment.USE_HBAR : FixedFeePayment.INVALID_PAYMENT;
        }

        private FixedFee.Builder asBuilder() {
            return switch (this.fixedFeePayment.ordinal()) {
                case 1 -> FixedFee.newBuilder().amount(this.amount);
                case 3 -> FixedFee.newBuilder().amount(this.amount).denominatingTokenId(this.tokenID);
                case 2 -> FixedFee.newBuilder().amount(this.amount).denominatingTokenId(TokenID.newBuilder().shardNum(0L).realmNum(0L).tokenNum(0L).build());
                default -> throw new InvalidTransactionException(ResponseCodeEnum.FAIL_INVALID);
            };
        }

        public FixedFeePayment getFixedFeePayment() {
            return this.fixedFeePayment;
        }

        public CustomFee asGrpc() {
            CustomFee.Builder feeBuilder = CustomFee.newBuilder().fixedFee(this.asBuilder().build());
            if (this.feeCollector != null) {
                feeBuilder.feeCollectorAccountId(this.feeCollector);
            }
            return feeBuilder.build();
        }

        public static enum FixedFeePayment {
            INVALID_PAYMENT,
            USE_HBAR,
            USE_CURRENTLY_CREATED_TOKEN,
            USE_EXISTING_FUNGIBLE_TOKEN;

        }
    }
}

