/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.node.app.service.contract.impl.state.AbstractProxyEvmAccount;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Set;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeFactory;

public class ProxyEvmAccount
extends AbstractProxyEvmAccount {
    private static final Set<Integer> ACCOUNT_PROXY_FUNCTION_SELECTOR = Set.of(Integer.valueOf(-1141991266), Integer.valueOf(-2035289988), Integer.valueOf(-177766759));
    @Nullable
    private Address address;

    public ProxyEvmAccount(AccountID accountID, @NonNull EvmFrameState state) {
        super(accountID, state);
    }

    @Override
    @NonNull
    public Code getEvmCode(@NonNull Bytes functionSelector, @NonNull CodeFactory codeFactory) {
        int selector;
        int n = selector = functionSelector.size() >= 4 ? functionSelector.getInt(0) : 0;
        if (ACCOUNT_PROXY_FUNCTION_SELECTOR.contains(selector)) {
            this.address = this.state.getAddress(this.accountID);
        }
        return codeFactory.createCode(this.getCode(), false);
    }

    @NonNull
    public Bytes getCode() {
        return this.state.getAccountRedirectCode(this.address);
    }

    @NonNull
    public Hash getCodeHash() {
        return this.state.getAccountRedirectCodeHash(this.address);
    }
}

