/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.hooks.EvmHookMappingEntries;
import com.hedera.hapi.node.hooks.EvmHookMappingEntry;
import com.hedera.hapi.node.hooks.EvmHookSpec;
import com.hedera.hapi.node.hooks.EvmHookStorageSlot;
import com.hedera.hapi.node.hooks.EvmHookStorageUpdate;
import com.hedera.hapi.node.hooks.HookCreation;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.hapi.node.state.hooks.EvmHookSlotKey;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.hapi.node.state.hooks.HookType;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.hapi.utils.contracts.HookUtils;
import com.hedera.node.app.service.contract.impl.schemas.V065ContractSchema;
import com.hedera.node.app.service.contract.impl.state.ReadableEvmHookStoreImpl;
import com.hedera.node.app.service.contract.impl.state.StorageAccess;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WritableEvmHookStore
extends ReadableEvmHookStoreImpl {
    private static final Logger log = LogManager.getLogger(WritableEvmHookStore.class);
    public static final Bytes ZERO_KEY = Bytes.fromHex((String)"00");
    private final WritableEntityCounters entityCounters;
    private final WritableKVState<HookId, EvmHookState> hookStates;
    private final WritableKVState<EvmHookSlotKey, SlotValue> storage;

    public WritableEvmHookStore(@NonNull WritableStates states, @NonNull WritableEntityCounters entityCounters) {
        super((ReadableStates)states);
        this.entityCounters = Objects.requireNonNull(entityCounters);
        this.hookStates = states.get(V065ContractSchema.EVM_HOOK_STATES_STATE_ID);
        this.storage = states.get(V065ContractSchema.EVM_HOOK_STORAGE_STATE_ID);
    }

    public int updateStorage(@NonNull HookId hookId, @NonNull List<EvmHookStorageUpdate> updates) throws HandleException {
        ArrayList<Bytes> keys = new ArrayList<Bytes>(updates.size());
        ArrayList<Bytes> values = new ArrayList<Bytes>(updates.size());
        for (EvmHookStorageUpdate update : updates) {
            if (update.hasStorageSlot()) {
                EvmHookStorageSlot slot = update.storageSlotOrThrow();
                keys.add(slot.key());
                values.add(slot.value());
                continue;
            }
            EvmHookMappingEntries entries = update.mappingEntriesOrThrow();
            Bytes p = HookUtils.leftPad32((Bytes)entries.mappingSlot());
            for (EvmHookMappingEntry entry : entries.entries()) {
                keys.add(HookUtils.slotKeyOfMappingEntry((Bytes)p, (EvmHookMappingEntry)entry));
                values.add(entry.value());
            }
        }
        return this.applyStorageMutations(hookId, keys, values);
    }

    public long numStorageSlotsInState() {
        return this.entityCounters.getCounterFor(EntityType.EVM_HOOK_STORAGE);
    }

    public void updateStorage(@NonNull EvmHookSlotKey key, @NonNull SlotValue value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.storage.put((Object)key, (Object)value);
    }

    public void remove(@NonNull HookId hookId) {
        Objects.requireNonNull(hookId);
        EvmHookState state = (EvmHookState)this.hookStates.get((Object)hookId);
        HandleException.validateTrue((state != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_NOT_FOUND);
        HandleException.validateTrue((state.numStorageSlots() == 0 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_DELETION_REQUIRES_ZERO_STORAGE_SLOTS);
        this.unlinkNeighbors(state);
        this.hookStates.remove((Object)hookId);
        this.entityCounters.decrementEntityTypeCounter(EntityType.HOOK);
    }

    private void unlinkNeighbors(@NonNull EvmHookState state) {
        HookId hookId = state.hookIdOrThrow();
        Long prevId = state.previousHookId();
        Long nextId = state.nextHookId();
        if (prevId != null) {
            HookId prev = HookId.newBuilder().hookId(prevId.longValue()).entityId(hookId.entityId()).build();
            EvmHookState prevState = (EvmHookState)this.hookStates.get((Object)prev);
            if (prevState != null) {
                this.hookStates.put((Object)prev, (Object)prevState.copyBuilder().nextHookId(nextId).build());
            } else {
                log.warn("Inconsistent state: previous hook {} not found when unlinking {}", (Object)prev, (Object)hookId);
            }
        }
        if (nextId != null) {
            HookId next = HookId.newBuilder().hookId(nextId.longValue()).entityId(hookId.entityId()).build();
            EvmHookState nextState = (EvmHookState)this.hookStates.get((Object)next);
            if (nextState != null) {
                this.hookStates.put((Object)next, (Object)nextState.copyBuilder().previousHookId(prevId).build());
            } else {
                log.warn("Inconsistent state: next hook {} not found when unlinking {}", (Object)next, (Object)hookId);
            }
        }
    }

    public int createEvmHook(@NonNull HookCreation creation, long maxNumber) throws HandleException {
        Objects.requireNonNull(creation);
        HandleException.validateTrue((this.entityCounters.getCounterFor(EntityType.HOOK) + 1L <= maxNumber ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
        HookCreationDetails details = creation.detailsOrThrow();
        HookId hookId = new HookId(creation.entityIdOrThrow(), details.hookId());
        HandleException.validateTrue((this.hookStates.get((Object)hookId) == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_ID_IN_USE);
        switch ((HookCreationDetails.HookOneOfType)details.hook().kind()) {
            case EVM_HOOK: {
                break;
            }
            default: {
                throw new IllegalStateException("Not an EVM hook - " + String.valueOf(creation));
            }
        }
        HookType type = HookType.EVM_HOOK;
        EvmHookSpec evmHookSpec = details.evmHookOrThrow().specOrThrow();
        EvmHookState state = EvmHookState.newBuilder().hookId(hookId).type(type).extensionPoint(details.extensionPoint()).hookContractId(evmHookSpec.contractIdOrThrow()).firstContractStorageKey(Bytes.EMPTY).previousHookId(null).nextHookId(creation.nextHookId()).numStorageSlots(0).adminKey(details.adminKey()).build();
        this.hookStates.put((Object)hookId, (Object)state);
        if (creation.nextHookId() != null) {
            HookId next = HookId.newBuilder().hookId(creation.nextHookId().longValue()).entityId(hookId.entityId()).build();
            EvmHookState nextState = (EvmHookState)this.hookStates.get((Object)next);
            if (nextState != null) {
                this.hookStates.put((Object)next, (Object)nextState.copyBuilder().previousHookId(Long.valueOf(details.hookId())).build());
            } else {
                log.warn("Inconsistent state: next hook {} not found when linking {}", (Object)next, (Object)hookId);
            }
        }
        List initialUpdates = details.evmHookOrThrow().storageUpdates();
        int updatedStorageSlots = 0;
        if (!initialUpdates.isEmpty()) {
            updatedStorageSlots = this.updateStorage(hookId, initialUpdates);
        }
        this.entityCounters.incrementEntityTypeCount(EntityType.HOOK);
        return updatedStorageSlots;
    }

    @Nullable
    public SlotValue getOriginalSlotValue(@NonNull EvmHookSlotKey key) {
        Objects.requireNonNull(key);
        return (SlotValue)this.storage.getOriginalValue((Object)key);
    }

    @NonNull
    private Bytes removeSlot(@NonNull HookId hookId, @NonNull Bytes firstKey, @NonNull Bytes key) {
        Objects.requireNonNull(firstKey);
        Objects.requireNonNull(hookId);
        Objects.requireNonNull(key);
        EvmHookSlotKey slotKey = new EvmHookSlotKey(hookId, key);
        try {
            SlotValue slotValue = this.slotValueFor(slotKey, "Missing key");
            Bytes nextKey = slotValue.nextKey();
            Bytes prevKey = slotValue.previousKey();
            if (!Bytes.EMPTY.equals((Object)nextKey)) {
                this.updatePrevFor(new EvmHookSlotKey(hookId, nextKey), prevKey);
            }
            if (!Bytes.EMPTY.equals((Object)prevKey)) {
                this.updateNextFor(new EvmHookSlotKey(hookId, prevKey), nextKey);
            }
            firstKey = key.equals((Object)firstKey) ? nextKey : firstKey;
        }
        catch (Exception irreparable) {
            log.error("Failed link management when removing {}; will be unable to expire all slots for hook {}", (Object)key, (Object)hookId, (Object)irreparable);
        }
        this.storage.remove((Object)slotKey);
        return firstKey;
    }

    public Set<EvmHookSlotKey> getModifiedEvmHookSlotKeys() {
        return this.storage.modifiedKeys();
    }

    @NonNull
    private Bytes insertSlot(@NonNull HookId hookId, @NonNull Bytes firstKey, @NonNull Bytes key, @NonNull Bytes value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Bytes minimalKey = WritableEvmHookStore.minimalKey(key);
        try {
            if (!Bytes.EMPTY.equals((Object)firstKey)) {
                this.updatePrevFor(new EvmHookSlotKey(hookId, firstKey), minimalKey);
            }
        }
        catch (Exception irreparable) {
            log.error("Failed link management when inserting {}; will be unable to expire all slots for contract {}", (Object)minimalKey, (Object)hookId, (Object)irreparable);
        }
        this.storage.put((Object)new EvmHookSlotKey(hookId, minimalKey), (Object)new SlotValue(value, Bytes.EMPTY, firstKey));
        return minimalKey;
    }

    public static EvmHookSlotKey minimalKey(@NonNull HookId hookId, @NonNull Bytes key) {
        return new EvmHookSlotKey(hookId, WritableEvmHookStore.minimalKey(key));
    }

    private void updatePrevFor(@NonNull EvmHookSlotKey key, @NonNull Bytes newPrevKey) {
        SlotValue value = this.slotValueFor(key, "Missing next key");
        this.storage.put((Object)key, (Object)value.copyBuilder().previousKey(newPrevKey).build());
    }

    private void updateNextFor(@NonNull EvmHookSlotKey key, @NonNull Bytes newNextKey) {
        SlotValue value = this.slotValueFor(key, "Missing prev key");
        this.storage.put((Object)key, (Object)value.copyBuilder().nextKey(newNextKey).build());
    }

    public static Bytes minimalKey(@NonNull Bytes key) {
        long len = key.length();
        if (len == 0L) {
            return ZERO_KEY;
        }
        int i = 0;
        while ((long)i < len && key.getByte((long)i) == 0) {
            ++i;
        }
        return (long)i == len ? ZERO_KEY : key.slice((long)i, len - (long)i);
    }

    public static boolean isAllZeroWord(@NonNull Bytes val) {
        long n = val.length();
        for (long i = 0L; i < n; ++i) {
            if (val.getByte(i) == 0) continue;
            return false;
        }
        return true;
    }

    @NonNull
    private SlotValue slotValueFor(@NonNull EvmHookSlotKey slotKey, @NonNull String msgOnError) {
        return Objects.requireNonNull((SlotValue)this.storage.get((Object)slotKey), () -> msgOnError + " " + String.valueOf(slotKey.key()));
    }

    private int applyStorageMutations(@NonNull HookId hookId, @NonNull List<Bytes> keys, @NonNull List<Bytes> values) {
        List<Bytes> filteredValues;
        List<Bytes> uniqueKeys;
        boolean[] skips = new boolean[keys.size()];
        HashSet<Bytes> seen = new HashSet<Bytes>();
        int numSkipped = 0;
        for (int i = keys.size() - 1; i >= 0; --i) {
            Bytes key = keys.get(i);
            if (seen.add(key)) continue;
            skips[i] = true;
            ++numSkipped;
        }
        if (numSkipped > 0) {
            int m = keys.size() - numSkipped;
            uniqueKeys = new ArrayList<Bytes>(m);
            filteredValues = new ArrayList<Bytes>(m);
            int n = keys.size();
            for (int i = 0; i < n; ++i) {
                if (skips[i]) continue;
                uniqueKeys.add(keys.get(i));
                filteredValues.add(values.get(i));
            }
        } else {
            uniqueKeys = keys;
            filteredValues = values;
        }
        ReadableEvmHookStoreImpl.EvmHookView view = this.getView(hookId, uniqueKeys);
        Bytes firstKey = view.firstStorageKey();
        int removals = 0;
        int insertions = 0;
        int n = uniqueKeys.size();
        for (int i = 0; i < n; ++i) {
            ReadableEvmHookStoreImpl.Slot slot = view.selectedSlots().get(i);
            SlotUpdate update = SlotUpdate.from(slot, filteredValues.get(i));
            firstKey = switch (update.asAccessType()) {
                case StorageAccess.StorageAccessType.REMOVAL -> {
                    ++removals;
                    yield this.removeSlot(hookId, firstKey, update.key());
                }
                case StorageAccess.StorageAccessType.INSERTION -> {
                    ++insertions;
                    yield this.insertSlot(hookId, firstKey, update.key(), update.newValueOrThrow());
                }
                case StorageAccess.StorageAccessType.UPDATE -> {
                    SlotValue slotValue = new SlotValue(update.newValueOrThrow(), slot.effectivePrevKey(), slot.effectiveNextKey());
                    this.storage.put((Object)slot.key(), (Object)slotValue);
                    yield firstKey;
                }
                default -> firstKey;
            };
        }
        if (insertions != 0 || removals != 0) {
            int delta = insertions - removals;
            this.entityCounters.adjustEntityCount(EntityType.EVM_HOOK_STORAGE, (long)delta);
            EvmHookState hookState = view.state();
            this.hookStates.put((Object)hookId, (Object)hookState.copyBuilder().firstContractStorageKey(firstKey).numStorageSlots(hookState.numStorageSlots() + delta).build());
            return delta;
        }
        return 0;
    }

    private ReadableEvmHookStoreImpl.EvmHookView getView(@NonNull HookId hookId, @NonNull List<Bytes> keys) throws HandleException {
        Objects.requireNonNull(hookId);
        Objects.requireNonNull(keys);
        EvmHookState state = (EvmHookState)this.hookStates.get((Object)hookId);
        if (state == null) {
            throw new HandleException(ResponseCodeEnum.HOOK_NOT_FOUND);
        }
        ArrayList<ReadableEvmHookStoreImpl.Slot> slots = new ArrayList<ReadableEvmHookStoreImpl.Slot>(keys.size());
        keys.forEach(key -> {
            EvmHookSlotKey slotKey = new EvmHookSlotKey(hookId, key);
            SlotValue slotValue = (SlotValue)this.storage.getOriginalValue((Object)slotKey);
            slots.add(new ReadableEvmHookStoreImpl.Slot(slotKey, slotValue));
        });
        return new ReadableEvmHookStoreImpl.EvmHookView(state, slots);
    }

    private record SlotUpdate(@NonNull Bytes key, @Nullable Bytes oldValue, @Nullable Bytes newValue) {
        public static SlotUpdate from(@NonNull ReadableEvmHookStoreImpl.Slot slot, @NonNull Bytes value) {
            return new SlotUpdate(slot.key().key(), slot.maybeBytesValue(), Bytes.EMPTY.equals((Object)value) ? null : value);
        }

        @NonNull
        public Bytes newValueOrThrow() {
            return Objects.requireNonNull(this.newValue);
        }

        public StorageAccess.StorageAccessType asAccessType() {
            if (this.oldValue == null) {
                return this.newValue == null ? StorageAccess.StorageAccessType.ZERO_INTO_EMPTY_SLOT : StorageAccess.StorageAccessType.INSERTION;
            }
            return this.newValue == null ? StorageAccess.StorageAccessType.REMOVAL : StorageAccess.StorageAccessType.UPDATE;
        }
    }
}

