/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.core;

import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletionStage;

public interface MethodHandler<ReqT, RespT>
extends ServerCalls.UnaryMethod<ReqT, RespT>,
ServerCalls.ClientStreamingMethod<ReqT, RespT>,
ServerCalls.ServerStreamingMethod<ReqT, RespT>,
ServerCalls.BidiStreamingMethod<ReqT, RespT> {
    public MethodDescriptor.MethodType type();

    public Class<?> getRequestType();

    public Class<?> getResponseType();

    public String javaMethodName();

    default public boolean clientOnly() {
        return false;
    }

    default public void invoke(ReqT request, StreamObserver<RespT> observer) {
        observer.onError((Throwable)Status.UNIMPLEMENTED.asException());
    }

    default public StreamObserver<ReqT> invoke(StreamObserver<RespT> observer) {
        observer.onError((Throwable)Status.UNIMPLEMENTED.asException());
        return null;
    }

    default public Object bidirectional(Object[] args, BidirectionalClient client) {
        throw Status.UNIMPLEMENTED.asRuntimeException();
    }

    default public Object clientStreaming(Object[] args, ClientStreaming client) {
        throw Status.UNIMPLEMENTED.asRuntimeException();
    }

    default public Object serverStreaming(Object[] args, ServerStreamingClient client) {
        throw Status.UNIMPLEMENTED.asRuntimeException();
    }

    default public Object unary(Object[] args, UnaryClient client) {
        throw Status.UNIMPLEMENTED.asRuntimeException();
    }

    public static interface UnaryClient {
        public <ReqT, RespT> CompletionStage<RespT> unary(String var1, ReqT var2);
    }

    public static interface ServerStreamingClient {
        public <ReqT, RespT> void serverStreaming(String var1, ReqT var2, StreamObserver<RespT> var3);
    }

    public static interface ClientStreaming {
        public <ReqT, RespT> StreamObserver<ReqT> clientStreaming(String var1, StreamObserver<RespT> var2);
    }

    public static interface BidirectionalClient {
        public <ReqT, RespT> StreamObserver<ReqT> bidiStreaming(String var1, StreamObserver<RespT> var2);
    }
}

