/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.Builder;
import io.helidon.common.config.Config;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.http.encoding.ContentEncoding;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.encoding.ContentEncodingContextConfig;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.MediaContextConfig;
import io.helidon.http.media.MediaSupport;
import io.helidon.service.registry.Service;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Routing;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.http.DirectHandlers;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.spi.ErrorHandlerProvider;
import io.helidon.webserver.spi.ProtocolConfig;
import io.helidon.webserver.spi.ServerConnectionSelector;
import io.helidon.webserver.spi.ServerFeature;
import java.util.List;
import java.util.Optional;

@Service.Singleton
class WebServerService {
    private final Optional<Config> config;
    private final List<ServerFeature> serverFeatures;
    private final List<HttpFeature> httpFeatures;
    private final List<ProtocolConfig> protocolConfigs;
    private final List<ContentEncoding> contentEncodings;
    private final List<MediaSupport> mediaSupports;
    private final List<ServerConnectionSelector> connectionSelectors;
    private final List<ErrorHandlerProvider<?>> httpErrorHandlers;
    private final Optional<DirectHandlers> directHandlers;
    private final Optional<RequestedUriDiscoveryContext> requestedUriDiscoveryContext;

    @Service.Inject
    WebServerService(Optional<Config> config, List<ServerFeature> serverFeatures, List<HttpFeature> httpFeatures, List<ProtocolConfig> protocolConfigs, List<ContentEncoding> contentEncodings, List<MediaSupport> mediaSupports, List<ServerConnectionSelector> connectionSelectors, List<ErrorHandlerProvider<?>> httpErrorHandlers, Optional<DirectHandlers> directHandlers, Optional<RequestedUriDiscoveryContext> requestedUriDiscoveryContext) {
        this.config = config;
        this.serverFeatures = serverFeatures;
        this.httpFeatures = httpFeatures;
        this.protocolConfigs = protocolConfigs;
        this.contentEncodings = contentEncodings;
        this.mediaSupports = mediaSupports;
        this.connectionSelectors = connectionSelectors;
        this.directHandlers = directHandlers;
        this.httpErrorHandlers = httpErrorHandlers;
        this.requestedUriDiscoveryContext = requestedUriDiscoveryContext;
    }

    void updateServerBuilder(WebServerConfig.BuilderBase<?, ?> builder) {
        ContentEncodingContextConfig.Builder ctxBuilder;
        Optional<ContentEncodingContext> ctx;
        if (builder.config().isEmpty()) {
            this.config.map(it -> it.get("server")).ifPresent(builder::config);
        }
        if (builder.requestedUriDiscoveryContext().isEmpty()) {
            this.requestedUriDiscoveryContext.ifPresent(builder::requestedUriDiscoveryContext);
        }
        this.protocolConfigs.forEach(builder::addProtocol);
        if (!this.contentEncodings.isEmpty()) {
            ctx = builder.contentEncoding();
            ctxBuilder = ContentEncodingContext.builder();
            ctx.ifPresent(contentEncodingContext -> ctxBuilder.from((ContentEncodingContextConfig)contentEncodingContext.prototype()));
            builder.contentEncoding(((ContentEncodingContextConfig.Builder)ctxBuilder.update(it -> this.contentEncodings.forEach(arg_0 -> ((ContentEncodingContextConfig.Builder)it).addContentEncoding(arg_0)))).build());
        }
        if (!this.mediaSupports.isEmpty()) {
            ctx = builder.mediaContext();
            ctxBuilder = MediaContextConfig.builder();
            ctx.ifPresent(arg_0 -> WebServerService.lambda$updateServerBuilder$3((MediaContextConfig.Builder)ctxBuilder, arg_0));
            builder.mediaContext(((MediaContextConfig.Builder)ctxBuilder.update(it -> this.mediaSupports.forEach(arg_0 -> ((MediaContextConfig.Builder)it).addMediaSupport(arg_0)))).build());
        }
        this.connectionSelectors.forEach(builder::addConnectionSelector);
        if (builder.requestedUriDiscoveryContext().isEmpty()) {
            this.requestedUriDiscoveryContext.ifPresent(builder::requestedUriDiscoveryContext);
        }
        this.serverFeatures.forEach(builder::addFeature);
        HttpRouting.Builder defaultRoutingBuilder = builder.routing().orElseGet(HttpRouting::builder);
        builder.routing(defaultRoutingBuilder);
        for (HttpFeature httpFeature : this.httpFeatures) {
            boolean routingFound;
            boolean useDefault;
            String socket = httpFeature.socket();
            boolean required = httpFeature.socketRequired();
            if ("@default".equals(socket)) {
                useDefault = true;
            } else {
                ListenerConfig listenerConfig = builder.sockets().get(socket);
                if (listenerConfig == null && required) {
                    throw new IllegalArgumentException("HTTP Feature " + String.valueOf(httpFeature) + " is configured to use socket \"" + socket + "\" and it must be present, but it is not");
                }
                useDefault = listenerConfig == null;
                String string = socket = useDefault ? "@default" : socket;
            }
            if (useDefault) {
                defaultRoutingBuilder.addFeature(httpFeature);
                continue;
            }
            List<Builder<?, Routing>> routingBuilders = builder.namedRoutings().get(socket);
            HttpRouting.Builder httpBuilder = null;
            boolean bl = routingFound = routingBuilders != null;
            if (routingFound) {
                routingFound = false;
                for (Builder<?, Routing> routingBuilder : routingBuilders) {
                    HttpRouting.Builder httpRouting;
                    if (!(routingBuilder instanceof HttpRouting.Builder)) continue;
                    httpBuilder = httpRouting = (HttpRouting.Builder)routingBuilder;
                    routingFound = true;
                    break;
                }
            }
            if (routingFound) {
                httpBuilder.addFeature(httpFeature);
                continue;
            }
            builder.routing(socket, it -> it.addFeature(httpFeature));
        }
        for (ErrorHandlerProvider errorHandlerProvider : this.httpErrorHandlers) {
            defaultRoutingBuilder.error(errorHandlerProvider.errorType(), errorHandlerProvider.create());
        }
        this.directHandlers.ifPresent(builder::directHandlers);
    }

    private static /* synthetic */ void lambda$updateServerBuilder$3(MediaContextConfig.Builder ctxBuilder, MediaContext mediaContext) {
        ctxBuilder.from((MediaContextConfig)mediaContext.prototype());
    }
}

