/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.networkadmin.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.TransactionGetRecordQuery;
import com.hedera.node.app.spi.fees.QueryFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.spi.workflows.QueryContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class TransactionGetRecordFeeCalculator
implements QueryFeeCalculator {
    public void accumulateNodePayment(@NonNull Query query, @NonNull SimpleFeeContext simpleFeeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        QueryContext queryContext = simpleFeeContext.queryContext();
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.TRANSACTION_GET_RECORD);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        if (queryContext != null) {
            RecordCache.History history;
            RecordCache recordCache = queryContext.recordCache();
            TransactionGetRecordQuery op = queryContext.query().transactionGetRecordOrThrow();
            int recordCount = 1;
            if ((op.includeDuplicates() || op.includeChildRecords()) && (history = recordCache.getHistory(op.transactionIDOrThrow())) != null) {
                recordCount += op.includeDuplicates() ? history.duplicateCount() : 0;
                recordCount += op.includeChildRecords() ? history.childRecords().size() : 0;
            }
            this.addExtraFee(feeResult, serviceDef, Extra.RECORDS, feeSchedule, recordCount);
        }
    }

    public Query.QueryOneOfType getQueryType() {
        return Query.QueryOneOfType.TRANSACTION_GET_RECORD;
    }
}

