/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.token.CryptoUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.hapi.fees.FeeKeyUtils;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class CryptoUpdateFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @NonNull SimpleFeeContext simpleFeeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        int hookOperations;
        CryptoUpdateTransactionBody op = txnBody.cryptoUpdateAccountOrThrow();
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CRYPTO_UPDATE);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        if (op.hasKey()) {
            this.addExtraFee(feeResult, serviceDef, Extra.KEYS, feeSchedule, FeeKeyUtils.countKeys((Key)op.key()));
        }
        if ((hookOperations = op.hookCreationDetails().size() + op.hookIdsToDelete().size()) > 0) {
            this.addExtraFee(feeResult, serviceDef, Extra.HOOK_UPDATES, feeSchedule, hookOperations);
        }
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CRYPTO_UPDATE_ACCOUNT;
    }
}

