/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.history.ConstructionNodeId;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.ProofKeySet;
import com.hedera.hapi.node.state.history.WrapsMessageHistory;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.platform.state.NodeId;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.hapi.platform.state.StateKey;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.history.HistoryService;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;

public class V071HistorySchema
extends Schema<SemanticVersion> {
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().minor(71).build();
    private static final long MAX_PROOF_KEYS = 0x200000L;
    private static final long MAX_PROOF_VOTES = 0x200000L;
    private static final long MAX_WRAPS_MESSAGE_HISTORIES = 0x200000L;
    public static final String LEDGER_ID_KEY = "LEDGER_ID";
    public static final int LEDGER_ID_STATE_ID = SingletonType.HISTORYSERVICE_I_LEDGER_ID.protoOrdinal();
    public static final String ACTIVE_PROOF_CONSTRUCTION_KEY = "ACTIVE_PROOF_CONSTRUCTION";
    public static final int ACTIVE_PROOF_CONSTRUCTION_STATE_ID = SingletonType.HISTORYSERVICE_I_ACTIVE_PROOF_CONSTRUCTION.protoOrdinal();
    public static final String NEXT_PROOF_CONSTRUCTION_KEY = "NEXT_PROOF_CONSTRUCTION";
    public static final int NEXT_PROOF_CONSTRUCTION_STATE_ID = SingletonType.HISTORYSERVICE_I_NEXT_PROOF_CONSTRUCTION.protoOrdinal();
    public static final String PROOF_KEY_SETS_KEY = "PROOF_KEY_SETS";
    public static final int PROOF_KEY_SETS_STATE_ID = StateKey.KeyOneOfType.HISTORYSERVICE_I_PROOF_KEY_SETS.protoOrdinal();
    public static final String PROOF_VOTES_KEY = "PROOF_VOTES";
    public static final int PROOF_VOTES_STATE_ID = StateKey.KeyOneOfType.HISTORYSERVICE_I_PROOF_VOTES.protoOrdinal();
    public static final String WRAPS_MESSAGE_HISTORIES_KEY = "WRAPS_MESSAGE_HISTORIES";
    public static final int WRAPS_MESSAGE_HISTORIES_STATE_ID = StateKey.KeyOneOfType.HISTORYSERVICE_I_WRAPS_MESSAGE_HISTORIES.protoOrdinal();
    private final HistoryService historyService;

    public V071HistorySchema(@NonNull HistoryService historyService) {
        super((Object)VERSION, HapiUtils.SEMANTIC_VERSION_COMPARATOR);
        this.historyService = Objects.requireNonNull(historyService);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.singleton((int)LEDGER_ID_STATE_ID, (String)LEDGER_ID_KEY, (Codec)ProtoBytes.PROTOBUF), StateDefinition.singleton((int)ACTIVE_PROOF_CONSTRUCTION_STATE_ID, (String)ACTIVE_PROOF_CONSTRUCTION_KEY, (Codec)HistoryProofConstruction.PROTOBUF), StateDefinition.singleton((int)NEXT_PROOF_CONSTRUCTION_STATE_ID, (String)NEXT_PROOF_CONSTRUCTION_KEY, (Codec)HistoryProofConstruction.PROTOBUF), StateDefinition.keyValue((int)PROOF_KEY_SETS_STATE_ID, (String)PROOF_KEY_SETS_KEY, (Codec)NodeId.PROTOBUF, (Codec)ProofKeySet.PROTOBUF), StateDefinition.keyValue((int)PROOF_VOTES_STATE_ID, (String)PROOF_VOTES_KEY, (Codec)ConstructionNodeId.PROTOBUF, (Codec)HistoryProofVote.PROTOBUF), StateDefinition.keyValue((int)WRAPS_MESSAGE_HISTORIES_STATE_ID, (String)WRAPS_MESSAGE_HISTORIES_KEY, (Codec)ConstructionNodeId.PROTOBUF, (Codec)WrapsMessageHistory.PROTOBUF));
    }

    public void restart(@NonNull MigrationContext ctx) {
        HistoryProofConstruction activeConstruction;
        if (!ctx.isGenesis() && ((TssConfig)ctx.appConfig().getConfigData(TssConfig.class)).historyEnabled() && (activeConstruction = Objects.requireNonNull((HistoryProofConstruction)ctx.newStates().getSingleton(ACTIVE_PROOF_CONSTRUCTION_STATE_ID).get())).hasTargetProof()) {
            this.historyService.setLatestHistoryProof(activeConstruction.targetProofOrThrow());
        }
    }
}

