/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterState;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.roster.RosterStateId;

public final class RosterRetriever {
    private static final String ROSTER_SERVICE = "RosterService";

    private RosterRetriever() {
    }

    @Nullable
    public static Roster retrieveActive(@NonNull State state, long round) {
        return RosterRetriever.retrieveInternal(state, RosterRetriever.getActiveRosterHash(state, round));
    }

    @Nullable
    public static Bytes getActiveRosterHash(@NonNull State state, long round) {
        ReadableSingletonState rosterState = state.getReadableStates(ROSTER_SERVICE).getSingleton(RosterStateId.ROSTER_STATE_STATE_ID);
        List roundRosterPairs = Objects.requireNonNull((RosterState)rosterState.get()).roundRosterPairs();
        for (RoundRosterPair roundRosterPair : roundRosterPairs) {
            if (roundRosterPair.roundNumber() > round) continue;
            return roundRosterPair.activeRosterHash();
        }
        return null;
    }

    @Nullable
    private static Roster retrieveInternal(@NonNull State state, @Nullable Bytes activeRosterHash) {
        if (activeRosterHash != null) {
            ReadableKVState rosterMap = state.getReadableStates(ROSTER_SERVICE).get(RosterStateId.ROSTERS_STATE_ID);
            return (Roster)rosterMap.get((Object)new ProtoBytes(activeRosterHash));
        }
        return null;
    }
}

