/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.util;

import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.export.ConfigExport;
import com.swirlds.config.extensions.sources.LegacyFileConfigSource;
import com.swirlds.config.extensions.sources.YamlConfigSource;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.JVMPauseDetectorThread;
import com.swirlds.platform.config.PathsConfig;
import com.swirlds.platform.config.internal.ConfigMappings;
import com.swirlds.platform.health.OSHealthCheckConfig;
import com.swirlds.platform.health.OSHealthChecker;
import com.swirlds.platform.health.clock.OSClockSpeedSourceChecker;
import com.swirlds.platform.health.entropy.OSEntropyChecker;
import com.swirlds.platform.health.filesystem.OSFileSystemChecker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.consensus.config.BasicConfig;

public final class BootstrapUtils {
    private static final Logger logger = LogManager.getLogger(BootstrapUtils.class);

    private BootstrapUtils() {
    }

    public static void setupConfigBuilder(@NonNull ConfigurationBuilder configurationBuilder, @NonNull Path settingsPath) throws IOException {
        BootstrapUtils.setupConfigBuilder(configurationBuilder, settingsPath, null);
    }

    public static void setupConfigBuilder(@NonNull ConfigurationBuilder configurationBuilder, @NonNull Path settingsPath, @Nullable Path nodeOverridesPath) throws IOException {
        LegacyFileConfigSource settingsConfigSource = LegacyFileConfigSource.ofSettingsFile((Path)settingsPath);
        ConfigSource mappedSettingsConfigSource = ConfigMappings.addConfigMapping((ConfigSource)settingsConfigSource);
        configurationBuilder.autoDiscoverExtensions().withSource(mappedSettingsConfigSource);
        if (nodeOverridesPath != null) {
            YamlConfigSource yamlConfigSource = new YamlConfigSource(nodeOverridesPath);
            configurationBuilder.withSource((ConfigSource)yamlConfigSource);
        }
    }

    public static void performHealthChecks(@NonNull Path settingsPath, @NonNull Configuration configuration) {
        Objects.requireNonNull(configuration);
        OSFileSystemChecker osFileSystemChecker = new OSFileSystemChecker(settingsPath);
        OSHealthChecker.performOSHealthChecks((OSHealthCheckConfig)configuration.getConfigData(OSHealthCheckConfig.class), List.of(OSClockSpeedSourceChecker::performClockSourceSpeedCheck, OSEntropyChecker::performEntropyChecks, osFileSystemChecker::performFileSystemCheck));
    }

    public static void setupConstructableRegistry() {
        try {
            ConstructableRegistry.getInstance().registerConstructables("");
        }
        catch (ConstructableRegistryException e) {
            throw new RuntimeException(e);
        }
    }

    public static void startJVMPauseDetectorThread(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration);
        BasicConfig basicConfig = (BasicConfig)configuration.getConfigData(BasicConfig.class);
        if (basicConfig.jvmPauseDetectorSleepMs() > 0) {
            JVMPauseDetectorThread jvmPauseDetectorThread = new JVMPauseDetectorThread((pauseTimeMs, allocTimeMs) -> {
                if (pauseTimeMs > (long)basicConfig.jvmPauseReportMs()) {
                    logger.warn(LogMarker.EXCEPTION.getMarker(), "jvmPauseDetectorThread detected JVM paused for {} ms, allocation pause {} ms", (Object)pauseTimeMs, (Object)allocTimeMs);
                }
            }, basicConfig.jvmPauseDetectorSleepMs());
            jvmPauseDetectorThread.start();
            logger.debug(LogMarker.STARTUP.getMarker(), "jvmPauseDetectorThread started");
        }
    }

    public static void writeSettingsUsed(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration);
        StringBuilder settingsUsedBuilder = new StringBuilder();
        PathsConfig pathsConfig = (PathsConfig)configuration.getConfigData(PathsConfig.class);
        settingsUsedBuilder.append(System.lineSeparator());
        settingsUsedBuilder.append("------------- All Configuration -------------");
        settingsUsedBuilder.append(System.lineSeparator());
        ConfigExport.addConfigContents((Configuration)configuration, (StringBuilder)settingsUsedBuilder);
        Path settingsUsedPath = pathsConfig.getSettingsUsedDir().resolve("settingsUsed.txt");
        try (FileOutputStream outputStream = new FileOutputStream(settingsUsedPath.toFile());){
            ((OutputStream)outputStream).write(settingsUsedBuilder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException | RuntimeException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to write settingsUsed to file {}", (Object)settingsUsedPath, (Object)e);
        }
    }
}

