/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import java.util.List;

public enum SignatureType implements EnumWithProtoMetadata
{
    SIGNATURE_TYPE_UNKNOWN(0, "SIGNATURE_TYPE_UNKNOWN"),
    SHA_384_WITH_RSA(1, "SHA_384_WITH_RSA"),
    UNRECOGNIZED(-1, "UNRECOGNIZED");

    private final int protoOrdinal;
    private final String protoName;

    private SignatureType(int protoOrdinal, String protoName) {
        this.protoOrdinal = protoOrdinal;
        this.protoName = protoName;
    }

    public int protoOrdinal() {
        return this.protoOrdinal;
    }

    public String protoName() {
        return this.protoName;
    }

    public static SignatureType fromProtobufOrdinal(int ordinal) {
        return switch (ordinal) {
            case 0 -> SIGNATURE_TYPE_UNKNOWN;
            case 1 -> SHA_384_WITH_RSA;
            default -> UNRECOGNIZED;
        };
    }

    public static SignatureType fromString(String name) {
        return switch (name) {
            case "SIGNATURE_TYPE_UNKNOWN" -> SIGNATURE_TYPE_UNKNOWN;
            case "SHA_384_WITH_RSA" -> SHA_384_WITH_RSA;
            default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
        };
    }

    public static SignatureType fromObject(Object obj) {
        if (obj == null) {
            return SignatureType.fromProtobufOrdinal(0);
        }
        if (obj instanceof SignatureType) {
            SignatureType pbjEnum = (SignatureType)((Object)obj);
            return pbjEnum;
        }
        return UNRECOGNIZED;
    }

    public static List<SignatureType> fromObjects(List<?> list) {
        return list.stream().map(SignatureType::fromObject).toList();
    }

    public static int toProtoOrdinal(Object obj) {
        if (obj instanceof SignatureType) {
            SignatureType pbjEnum = (SignatureType)((Object)obj);
            return pbjEnum.protoOrdinal();
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return i;
        }
        throw new IllegalArgumentException("Neither SignatureType, nor Integer, but: " + obj.getClass().getName());
    }

    public static List<Integer> toProtoOrdinals(List<?> list) {
        return list.stream().map(SignatureType::toProtoOrdinal).toList();
    }

    public static int compare(Object o1, Object o2) {
        int i2;
        int i1;
        if (o1 instanceof SignatureType) {
            SignatureType e1 = (SignatureType)((Object)o1);
            if (o2 instanceof SignatureType) {
                SignatureType e2 = (SignatureType)((Object)o2);
                return e1.compareTo(e2);
            }
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        if (o1 instanceof SignatureType) {
            SignatureType e1 = (SignatureType)((Object)o1);
            i1 = e1.protoOrdinal();
        } else if (o1 instanceof Integer) {
            Integer ii1 = (Integer)o1;
            i1 = ii1;
        } else {
            throw new IllegalArgumentException("o1 is neither SignatureType, nor Integer. It's: " + o1.getClass().getName());
        }
        if (o2 instanceof SignatureType) {
            SignatureType e2 = (SignatureType)((Object)o2);
            i2 = e2.protoOrdinal();
        } else if (o2 instanceof Integer) {
            Integer ii2 = (Integer)o2;
            i2 = ii2;
        } else {
            throw new IllegalArgumentException("o2 is neither SignatureType, nor Integer. It's: " + o2.getClass().getName());
        }
        return Integer.compare(i1, i2);
    }
}

